/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.internal.base.InvalidLicensingConfiguration;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class ApplicationVersion
implements Supplier<String> {
    private final IApplicationContext context;

    public ApplicationVersion(IApplicationContext context) {
        this.context = context;
    }

    @Override
    public String get() {
        Optional property = new ProductVersion(arg_0 -> ((IApplicationContext)this.context).getBrandingProperty(arg_0)).get();
        if (property.isPresent()) {
            return (String)property.get();
        }
        Bundle bundle = this.context.getBrandingBundle();
        if (bundle == null) {
            return new InvalidLicensingConfiguration().getProductVersion();
        }
        return this.stringify(bundle.getVersion());
    }

    private String stringify(Version version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version.getMajor()).append('.');
        sb.append(version.getMinor()).append('.');
        sb.append(version.getMicro());
        return sb.toString();
    }
}

