/*******************************************************************************
 * Copyright (c) 2020 ArSysOp
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     ArSysOp - initial API and implementation
 *******************************************************************************/
package org.eclipse.passage.lic.internal.base.io;

import java.nio.file.Path;
import java.util.function.Supplier;

import org.eclipse.passage.lic.internal.api.LicensedProduct;

public final class UserHomeProductResidence implements Supplier<Path> {

	private final Supplier<Path> residence;

	public UserHomeProductResidence(LicensedProduct product) {
		residence = new PathFromLicensedProduct(new LicensingFolder(new UserHomePath()), product);
	}

	@Override
	public Path get() {
		Path path = residence.get();
		path.toFile().mkdirs();
		return path;
	}

}
