/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;

public final class CertificateSerializer
extends StdSerializer<ExaminationCertificate> {
    private static final long serialVersionUID = -8642464467092910399L;

    CertificateSerializer(Class<ExaminationCertificate> type) {
        super(type);
    }

    public void serialize(ExaminationCertificate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("stamp", (Object)value.stamp());
        this.writeCollection(value.satisfied(), gen, "requirements");
        this.writeCollection(value.restrictions(), gen, "restrictions");
        this.writeCollection(this.permissions(value), gen, "permissions");
        gen.writeEndObject();
    }

    private <T> void writeCollection(Collection<T> items, JsonGenerator gen, String name) throws IOException {
        gen.writeArrayFieldStart(name);
        for (T item : items) {
            gen.writeObject(item);
        }
        gen.writeEndArray();
    }

    private List<Permission> permissions(ExaminationCertificate certificate) {
        return certificate.satisfied().stream().map(requirement -> certificate.satisfaction(requirement)).collect(Collectors.toList());
    }

    private String date(ZonedDateTime time) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(time);
    }
}

