/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.emf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.GearSupplier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.emf.resource.ResourceLoadFailed;
import org.eclipse.passage.lic.internal.emf.i18n.EmfMessages;
import org.eclipse.passage.loc.internal.api.OperatorGear;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;

public abstract class BaseDomainRegistry<I>
implements EditingDomainRegistry<I>,
IEditingDomainProvider {
    protected String domainName;
    private final AdapterFactoryEditingDomain editingDomain;
    private final List<URI> sources = new ArrayList<URI>();
    private final EContentAdapter contentAdapter;
    private final List<OperatorGearSupplier> gear = new ArrayList<OperatorGearSupplier>(1);

    public BaseDomainRegistry() {
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)commandStack, new HashMap());
        this.contentAdapter = this.createContentAdapter();
    }

    public void bindGear(OperatorGearSupplier supplier) {
        this.gear.add(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        this.gear.remove(supplier);
    }

    protected void activate(Map<String, Object> properties) {
        this.domainName = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.contentAdapter);
        try {
            this.gear.stream().findFirst().map(GearSupplier::gear).map(OperatorGear::workspace).ifPresent(this::load);
        }
        catch (Exception e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }

    private void load(OperatorWorkspace workspace) {
        this.knownResources(workspace).all().stream().filter(this::emfResource).map(ResourceHandle::uri).map(URI::createURI).forEach(this::registerSource);
    }

    protected abstract boolean emfResource(ResourceHandle var1);

    protected abstract KnownResources knownResources(OperatorWorkspace var1);

    protected void logDiagnostic(Diagnostic diagnostic) {
        Platform.getLog(this.getClass()).error(new DiagnosticExplained(diagnostic).get());
    }

    protected abstract DomainContentAdapter<I, ? extends EditingDomainRegistry<I>> createContentAdapter();

    protected void deactivate(Map<String, Object> properties) {
        try {
            this.gear.stream().findFirst().map(GearSupplier::gear).map(OperatorGear::workspace).ifPresent(this::store);
        }
        catch (Exception e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.contentAdapter);
    }

    private void store(OperatorWorkspace workspace) {
        this.knownResources(workspace).memento(this.getSources().stream().map(Object::toString).collect(Collectors.toList()));
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Map<?, ?> getLoadOptions() {
        return new HashMap();
    }

    protected Map<?, ?> getSaveOptions() {
        return new HashMap();
    }

    public ServiceInvocationResult<Boolean> loadSource(URI uri) {
        ResourceSet set = this.editingDomain.getResourceSet();
        Resource resource = this.createResource(uri);
        set.getResources().add((Object)resource);
        try {
            resource.load(this.getLoadOptions());
            resource.eAdapters().add((Object)this.contentAdapter);
            return new BaseServiceInvocationResult((Object)true);
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ResourceLoadFailed(), NLS.bind((String)EmfMessages.BaseDomainRegistry_e_load_failed, (Object)uri), (Exception)e));
        }
    }

    protected abstract Resource createResource(URI var1);

    public void unloadSource(URI uri) {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Resource resource = resourceSet.getResource(uri, false);
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    @Override
    public ServiceInvocationResult<Boolean> registerSource(URI uri) {
        this.sources.add(uri);
        return this.loadSource(uri);
    }

    @Override
    public void unregisterSource(URI uri) {
        this.sources.remove(uri);
        this.unloadSource(uri);
    }

    @Override
    public List<URI> getSources() {
        return Collections.unmodifiableList(this.sources);
    }
}

