/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.api.conditions.VersionMatch;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Feature;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.conditions.BaseCondition;
import org.eclipse.passage.lic.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.base.conditions.BaseIssuerSignature;
import org.eclipse.passage.lic.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.base.conditions.BaseVersionMatch;
import org.eclipse.passage.lic.base.conditions.MatchingRuleForIdentifier;
import org.eclipse.passage.lic.base.conditions.evaluation.BasePermission;
import org.eclipse.passage.lic.base.requirements.BaseFeature;
import org.eclipse.passage.lic.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.base.restrictions.BaseRestriction;

public abstract class Json<T>
implements Function<JsonNode, T> {

    public static final class Date
    extends Json<ZonedDateTime> {
        @Override
        public ZonedDateTime apply(JsonNode node) {
            return this.date(node.get("formatted").textValue());
        }

        private ZonedDateTime date(String source) {
            return ZonedDateTime.parse(source, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
    }

    public static final class LicensingCondition
    extends Json<Condition> {
        @Override
        public Condition apply(JsonNode node) {
            return new BaseCondition(node.get("identifier").textValue(), node.get("feature").textValue(), (VersionMatch)new BaseVersionMatch(node.get("version").textValue(), new MatchingRuleForIdentifier(node.get("rule").textValue()).get()), (ValidityPeriod)new BaseValidityPeriodClosed(new Date().apply(node.get("period-closed-from")), new Date().apply(node.get("period-closed-to"))), (EvaluationInstructions)new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(node.get("type").textValue()), node.get("expression").textValue()));
        }
    }

    public static final class LicensingConditionOrigin
    extends Json<ConditionOrigin> {
        @Override
        public ConditionOrigin apply(JsonNode node) {
            return new BaseConditionOrigin((ConditionMiningTarget)new ConditionMiningTarget.Of(node.get("miner").textValue()), node.get("coordinates").textValue(), (IssuerSignature)new BaseIssuerSignature());
        }
    }

    public static final class LicensingPermission
    extends Json<Permission> {
        @Override
        public Permission apply(JsonNode node) {
            return new BasePermission(new Product().apply(node.get("product")), new LicensingCondition().apply(node.get("condition")), new Date().apply(node.get("lease")), new Date().apply(node.get("expiration")), new LicensingConditionOrigin().apply(node.get("origin")));
        }
    }

    public static final class LicensingRequirement
    extends Json<Requirement> {
        @Override
        public Requirement apply(JsonNode node) {
            return new BaseRequirement(new ProductFeature().apply(node.get("feature")), (RestrictionLevel)new RestrictionLevelOf().apply(node.get("restriction")), (Object)node.get("source").textValue());
        }
    }

    public static final class LicensingRestriction
    extends Json<Restriction> {
        @Override
        public Restriction apply(JsonNode node) {
            return new BaseRestriction(new Product().apply(node.get("product")), new LicensingRequirement().apply(node.get("requirement")), new Reason().apply(node.get("reason")));
        }
    }

    public static final class Product
    extends Json<LicensedProduct> {
        @Override
        public LicensedProduct apply(JsonNode node) {
            return new BaseLicensedProduct(node.get("identifier").textValue(), node.get("version").textValue());
        }
    }

    public static final class ProductFeature
    extends Json<Feature> {
        @Override
        public Feature apply(JsonNode node) {
            return new BaseFeature(node.get("id").textValue(), node.get("version").textValue(), node.get("name").textValue(), node.get("provider").textValue());
        }
    }

    public static final class Reason
    extends Json<TroubleCode> {
        @Override
        public TroubleCode apply(JsonNode node) {
            return new TroubleCode.Of(node.get("code").intValue(), node.get("explanation").textValue());
        }
    }

    public static final class RestrictionLevelOf
    extends Json<RestrictionLevel.Of> {
        @Override
        public RestrictionLevel.Of apply(JsonNode node) {
            return new RestrictionLevel.Of(node.get("identifier").textValue());
        }
    }
}

