/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.sorters;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class TreeTableComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private String fColumnName = null;
    private int fDirection = 1;

    public int getDirection() {
        return 1 == this.fDirection ? 1024 : 128;
    }

    public void setColumnName(String aColumnName) {
        if (this.fColumnName != null && aColumnName.equals(this.fColumnName)) {
            this.fDirection = 1 - this.fDirection;
        } else {
            this.fColumnName = aColumnName;
            this.fDirection = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        int compareResult = 0;
        if ("Elements".equals(this.fColumnName)) {
            if (e1 instanceof IR4EUIModelElement && e2 instanceof IR4EUIModelElement) {
                String str1 = ((IR4EUIModelElement)e1).getName();
                String str2 = ((IR4EUIModelElement)e2).getName();
                compareResult = str1.compareTo(str2);
            } else {
                compareResult = 0;
            }
        } else if ("Path".equals(this.fColumnName)) {
            if (e1 instanceof R4EUIFileContext && e2 instanceof R4EUIFileContext) {
                String str1 = "";
                String str2 = "";
                R4EFileVersion fileVersion = ((R4EUIFileContext)e1).getTargetFileVersion();
                if (fileVersion != null) {
                    str1 = UIUtils.getProjectPath(fileVersion);
                } else {
                    fileVersion = ((R4EUIFileContext)e1).getBaseFileVersion();
                    if (fileVersion != null) {
                        str1 = UIUtils.getProjectPath(fileVersion);
                    }
                }
                fileVersion = ((R4EUIFileContext)e2).getTargetFileVersion();
                if (fileVersion != null) {
                    str2 = UIUtils.getProjectPath(fileVersion);
                } else {
                    fileVersion = ((R4EUIFileContext)e2).getBaseFileVersion();
                    if (fileVersion != null) {
                        str2 = UIUtils.getProjectPath(fileVersion);
                    }
                }
                compareResult = str1.compareTo(str2);
            } else {
                compareResult = 0;
            }
        } else if ("Assigned to".equals(this.fColumnName)) {
            if (e1 instanceof R4EUIReviewItem && e2 instanceof R4EUIReviewItem) {
                String str1 = UIUtils.formatAssignedParticipants((EList<String>)((R4EUIReviewItem)e1).getItem().getAssignedTo());
                String str2 = UIUtils.formatAssignedParticipants((EList<String>)((R4EUIReviewItem)e2).getItem().getAssignedTo());
                compareResult = str1.compareTo(str2);
            } else if (e1 instanceof R4EUIFileContext && e2 instanceof R4EUIFileContext) {
                String str1 = UIUtils.formatAssignedParticipants((EList<String>)((R4EUIFileContext)e1).getFileContext().getAssignedTo());
                String str2 = UIUtils.formatAssignedParticipants((EList<String>)((R4EUIFileContext)e2).getFileContext().getAssignedTo());
                compareResult = str1.compareTo(str2);
            } else {
                compareResult = 0;
            }
        } else if ("Changes".equals(this.fColumnName)) {
            if (e1 instanceof R4EUIReviewItem && e2 instanceof R4EUIReviewItem) {
                int num1 = ((R4EUIReviewItem)e1).getNumChanges();
                int num2 = ((R4EUIReviewItem)e2).getNumChanges();
                compareResult = num1 - num2;
            } else if (e1 instanceof R4EUIFileContext && e2 instanceof R4EUIFileContext) {
                int num1 = ((R4EUIFileContext)e1).getNumChanges();
                int num2 = ((R4EUIFileContext)e2).getNumChanges();
                compareResult = num1 - num2;
            } else {
                compareResult = 0;
            }
        } else if ("Anomalies".equals(this.fColumnName)) {
            if (e1 instanceof R4EUIReviewItem && e2 instanceof R4EUIReviewItem) {
                int num1 = ((R4EUIReviewItem)e1).getNumAnomalies();
                int num2 = ((R4EUIReviewItem)e2).getNumAnomalies();
                compareResult = num1 - num2;
            } else if (e1 instanceof R4EUIFileContext && e2 instanceof R4EUIFileContext) {
                int num1 = ((R4EUIFileContext)e1).getNumAnomalies();
                int num2 = ((R4EUIFileContext)e2).getNumAnomalies();
                compareResult = num1 - num2;
            } else {
                compareResult = 0;
            }
        }
        if (this.fDirection == 1) {
            compareResult = -compareResult;
        }
        return compareResult;
    }
}

