/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.EclException;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ImageEntry;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.rcptt.reporting.util.IndentedWriter;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaException;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaStackTraceEntry;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.utils.AdvancedInformationGenerator;
import org.eclipse.rcptt.util.StringUtils;

public class RcpttReportGenerator {
    private final SimpleReportGenerator simpleReportGenerator = new SimpleReportGenerator();
    private final List<ImageEntry> images;
    private final PrintWriter writer;
    private long startTime = 0L;

    public RcpttReportGenerator(PrintWriter writer, List<ImageEntry> images) {
        this.writer = writer;
        this.images = images;
    }

    protected PrintWriter writeTabs(int tabs) {
        return RcpttReportGenerator.writeTabs(this.writer, tabs);
    }

    public void writeReport(Report report, int tabs) {
        this.startTime = report.getRoot().getStartTime();
        this.printNode(report.getRoot(), tabs);
    }

    protected static <T extends Appendable> T writeTabs(T writer, int tabs) {
        int i = 0;
        while (i < tabs) {
            try {
                writer.append("  ");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return writer;
    }

    public void printNode(Node infoNode, int tabs) {
        this.writeQ7Info(tabs, infoNode);
        this.writeQ7WaitInfo(tabs, infoNode);
        this.writeLogsFromNode(tabs, infoNode);
        try {
            for (Event child : infoNode.getEvents()) {
                this.writeEvent(child, tabs + 1);
            }
            for (Event child : infoNode.getSnapshots()) {
                this.writeSnapshot((Snaphot)child, tabs + 1);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.printChildren(tabs, infoNode);
    }

    private void writeEvent(Event event, int tabs) throws IOException {
        this.writeTabs(tabs + 1).println("Event " + TimeFormatHelper.format((long)(event.getTime() - this.startTime)));
        this.printObject(event.getData(), tabs + 2);
    }

    public void printObject(EObject object, int tabs) throws IOException {
        if (object instanceof EclipseStatus) {
            this.printStatus((EclipseStatus)object, tabs);
        } else if (object instanceof Snaphot) {
            this.writeSnapshot((Snaphot)object, tabs);
        } else {
            this.simpleReportGenerator.toString((Appendable)this.writer, tabs, object, new String[0]);
        }
    }

    private void writeSnapshot(Snaphot snapshot, int tabs) throws IOException {
        if (snapshot.getData() instanceof Screenshot) {
            Screenshot shot = (Screenshot)snapshot.getData();
            String description = String.valueOf(shot.getMessage()) + ": " + TimeFormatHelper.format((long)(snapshot.getTime() - this.startTime));
            this.images.add(new ImageEntry(shot.getData(), description));
            return;
        }
        if (snapshot.getData() instanceof AdvancedInformation) {
            this.printAdvanced((AdvancedInformation)snapshot.getData(), tabs);
            return;
        }
        this.writeTabs(tabs).println("Snapshot " + TimeFormatHelper.format((long)(snapshot.getTime() - this.startTime)));
        this.printObject(snapshot.getData(), tabs + 1);
    }

    private void printAdvanced(AdvancedInformation data, int tabs) {
        new AdvancedInformationGenerator(this.writer).writeAdvanced(data, tabs);
    }

    private PrintWriter w(int tabs) {
        return this.writeTabs(tabs);
    }

    private void printStatus(EclipseStatus status, int tabs) throws IOException {
        SimpleSeverity severity = SimpleSeverity.create((int)status.getSeverity());
        this.w(tabs).append(severity.name());
        this.writer.append(" in plugin: ").println(status.getPlugin());
        this.w(tabs).append("message: ").println(status.getMessage());
        if (status.getException() != null) {
            this.w(tabs).println("exception: ");
            this.printJavaException(status.getException(), tabs + 2);
        }
        for (EclipseStatus child : status.getChildren()) {
            this.printStatus(child, tabs + 1);
        }
    }

    private void printJavaException(JavaException e, int tabs) {
        this.w(tabs).append(e.getClassName());
        if (!StringUtils.isEmpty((String)e.getMessage())) {
            this.writer.print(":" + e.getMessage());
        }
        this.writer.println();
        for (JavaStackTraceEntry st : e.getStackTrace()) {
            this.w(tabs + 2).append("at ").append(st.getClassName()).append(".").append(st.getMethodName()).append("(").append(st.getFileName()).append(":").append("" + st.getLineNumber()).append(")").println();
        }
        JavaException cause = e.getCause();
        if (cause != null) {
            this.w(tabs + 2).println("Caused by:");
            this.printJavaException(cause, tabs + 1);
        }
    }

    protected void printChildren(int tabs, Node infoNode) {
        for (Node child : infoNode.getChildren()) {
            this.printNode(child, tabs + 4);
        }
    }

    private void writeQ7WaitInfo(int tabs, Node infoNode) {
        Q7WaitInfoRoot waitInfo = ReportHelper.getWaitInfo((Node)infoNode, (boolean)false);
        if (waitInfo != null) {
            this.writeQ7WaitInfo(tabs, waitInfo);
        }
    }

    public static String getType(Q7WaitInfoRoot info, Q7WaitInfo q7WaitInfo) {
        String type = (String)info.getTypesNames().get(q7WaitInfo.getTypeId());
        if (!TeslaFeatures.isIncludeIgnoredWaitDetails() && type.contains("(ignored)")) {
            return null;
        }
        return type;
    }

    public void writeQ7WaitInfo(int tabs, Q7WaitInfoRoot info) {
        ArrayList infos = new ArrayList(info.getInfos());
        Collections.sort(infos, new Comparator<Q7WaitInfo>(){

            @Override
            public int compare(Q7WaitInfo o1, Q7WaitInfo o2) {
                return Long.valueOf(o1.getLastTick()).compareTo(o2.getLastTick());
            }
        });
        if (infos.size() == 0) {
            return;
        }
        long endTime = info.getStartTime();
        int total = 0;
        for (Q7WaitInfo q7WaitInfo : infos) {
            if (RcpttReportGenerator.getType(info, q7WaitInfo) == null) continue;
            if (endTime < q7WaitInfo.getEndTime()) {
                endTime = q7WaitInfo.getEndTime();
            }
            ++total;
        }
        if (total == 0) {
            return;
        }
        this.writeTabs(tabs + 4).append("--> q7 wait details <-- total wait time: ").append(Long.toString(endTime - info.getStartTime())).println();
        for (Q7WaitInfo i : infos) {
            long totalTime = i.getEndTime() - i.getStartTime();
            String className = SimpleReportGenerator.getClassName((Q7WaitInfoRoot)info, (Q7WaitInfo)i);
            String type = RcpttReportGenerator.getType(info, i);
            if (type == null) continue;
            this.writeTabs(tabs + 8).append(type).append(": ").append(className);
            if (totalTime != 0L) {
                this.writer.append(", total time: ").append(Long.toString(totalTime));
            }
            if (i.getLastTick() > 0L) {
                this.writer.append(", ticks: ").append(Long.toString(i.getLastTick() - i.getTicks() + 1L));
                this.writer.append(" to ").append(Long.toString(i.getLastTick()));
            }
            this.writer.println();
        }
    }

    String kindToString(ItemKind kind, String name) {
        switch (kind) {
            case CONTEXT: {
                return "Context *" + name + "*";
            }
            case ECL_COMMAND: {
                return name;
            }
            case SCRIPT: {
                return "Script *" + name + "*";
            }
            case TESTCASE: {
                return "Test case *" + name + "*";
            }
            case TEST_SUITE: {
                return "Test suite *" + name + "*";
            }
            case VERIFICATION: {
                return "Verification *" + name + "*";
            }
        }
        return name;
    }

    private void writeQ7Info(int tabs, Node infoNode) {
        Q7Info q7Info = ReportHelper.getInfo((Node)infoNode);
        this.writeTabs(tabs);
        if (q7Info != null) {
            this.writer.append(this.kindToString(q7Info.getType(), infoNode.getName()));
            this.writer.append(" ").append("time: " + TimeFormatHelper.format((long)(infoNode.getEndTime() - infoNode.getStartTime()))).println();
            this.writeResult(tabs + 1, q7Info.getResult());
        }
    }

    public void writeResult(int tabs, ProcessStatus result) {
        if (result == null) {
            result = RcpttPlugin.createProcessStatus((int)4, (String)"Null result");
        }
        if (SimpleSeverity.create((ProcessStatus)result) == SimpleSeverity.OK) {
            return;
        }
        this.w(tabs).append("Result: " + SimpleSeverity.create((ProcessStatus)result).name() + ", message: ").println(result.getMessage());
        RcpttReportGenerator.writeException(this.writer, tabs + 1, result.getException());
        for (ProcessStatus child : result.getChildren()) {
            this.writeResult(tabs + 1, child);
        }
    }

    private static void writeException(Writer writer, final int tabs, EclException exception) {
        if (exception == null) {
            return;
        }
        IndentedWriter iwriter = new IndentedWriter(writer){

            @Override
            public void writeIndent() {
                RcpttReportGenerator.writeTabs(this, tabs);
            }
        };
        ProcessStatusConverter.getThrowable((EclException)exception).printStackTrace(iwriter);
        iwriter.println();
        iwriter.flush();
    }

    public void writeLogsFromNode(int tabs, Node infoNode) {
        boolean haveEntries = false;
        for (LoggingCategory logCategory : LoggingCategory.VALUES) {
            String log = ReportBuilder.getLogs((Node)infoNode, (LoggingCategory)logCategory);
            if (StringUtils.isEmpty((String)log)) continue;
            if (!haveEntries) {
                haveEntries = true;
                this.writeTabs(tabs).println("--------------Logs BEGIN-------------------");
            }
            String[] stringArray = log.split("[\r\n]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String logLine = stringArray[n2];
                this.writeTabs(tabs).append(logLine).println();
                ++n2;
            }
        }
        if (haveEntries) {
            this.writeTabs(tabs).append("--------------Logs END-------------------").println();
        }
    }
}

