/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.persistence;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.LogFactory;

public class ErrorLogVerificationPlainExtension
implements IPlainTextPersistenceExtension {
    private static final String ERROR_LOG_VERIFICATION_FILE = ".errorlog.verification";

    public boolean isContentEntryOptional(EList<EObject> contents) {
        return contents.get(0) instanceof ErrorLogVerification;
    }

    private static String predicateToLine(LogEntryPredicate p) {
        return String.format("%d %d %s Message:%s", p.getSeverityMask(), p.getCode(), StringUtils.nullToEmpty((String)p.getPluginPattern()).replaceAll("\n| ", ""), StringUtils.nullToEmpty((String)p.getMessagePattern()).replaceAll("\n", " "));
    }

    private static LogEntryPredicate parsePredicate(String line) throws IOException {
        String[] data = line.split(" ", 4);
        if (data.length != 4) {
            throw new IOException("Invalid format " + line);
        }
        LogEntryPredicate rv = LogFactory.eINSTANCE.createLogEntryPredicate();
        rv.setSeverityMask(Integer.valueOf(data[0]));
        rv.setCode(Integer.valueOf(data[1]));
        rv.setPluginPattern(data[2]);
        if (!data[3].startsWith("Message:")) {
            throw new IOException("No message found in " + line);
        }
        rv.setMessagePattern(data[3].substring(8));
        return rv;
    }

    private static void savePredicates(List<LogEntryPredicate> predicates, Writer output) throws IOException {
        for (LogEntryPredicate predicate : predicates) {
            String line = ErrorLogVerificationPlainExtension.predicateToLine(predicate);
            assert (!line.contains("\n"));
            output.write(line);
            output.write("\n");
        }
    }

    public void updateAttributes(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> masterAttributes, EObject eObject) {
        if (eObject instanceof ErrorLogVerification) {
            ErrorLogVerification elv = (ErrorLogVerification)eObject;
            OutputStream store = plainTextPersistenceModel.store(ERROR_LOG_VERIFICATION_FILE);
            try {
                OutputStreamWriter writer = new OutputStreamWriter(store, "utf-8");
                try {
                    try {
                        if (!elv.getRequired().isEmpty()) {
                            writer.write("REQUIRED:\n");
                            ErrorLogVerificationPlainExtension.savePredicates(elv.getRequired(), writer);
                        }
                        if (!elv.getAllowed().isEmpty()) {
                            writer.write("ALLOWED:\n");
                            ErrorLogVerificationPlainExtension.savePredicates(elv.getAllowed(), writer);
                        }
                        if (!elv.getDenied().isEmpty()) {
                            writer.write("DENIED:\n");
                            ErrorLogVerificationPlainExtension.savePredicates(elv.getDenied(), writer);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    FileUtil.safeClose((Closeable)writer);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void updateMetadata(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> header, EObject eObject) {
        if (eObject instanceof ErrorLogVerification) {
            ErrorLogVerification elv = (ErrorLogVerification)eObject;
            InputStream stream = plainTextPersistenceModel.read(ERROR_LOG_VERIFICATION_FILE);
            if (stream == null) {
                throw new RuntimeException("Can't read verification contents");
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                try {
                    EList<LogEntryPredicate> predicates = elv.getRequired();
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line == null) {
                            return;
                        }
                        try {
                            if (line.contentEquals("REQUIRED:")) {
                                predicates = elv.getRequired();
                                continue;
                            }
                            if (line.contentEquals("ALLOWED:")) {
                                predicates = elv.getAllowed();
                                continue;
                            }
                            if (line.contentEquals("DENIED:")) {
                                predicates = elv.getDenied();
                                continue;
                            }
                            if (line.isEmpty()) continue;
                            predicates.add(ErrorLogVerificationPlainExtension.parsePredicate(line));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                finally {
                    FileUtil.safeClose((Closeable)reader);
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public void performObjectPreSaveUpdate(EObject eObject) {
        if (eObject instanceof ErrorLogVerification) {
            ErrorLogVerification elv = (ErrorLogVerification)eObject;
            elv.getAllowed().clear();
            elv.getDenied().clear();
            elv.getRequired().clear();
        }
    }

    public String getTextContentType(String fName) {
        if (ERROR_LOG_VERIFICATION_FILE.equals(fName)) {
            return "text/errorlog-verification";
        }
        return null;
    }
}

