/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;

public class ContextManagement {
    private static Stack<Context> contexts = new Stack();
    private static Context lastLeavedContext = null;
    private static final Map<String, Context> contextUUID = new HashMap<String, Context>();
    private static final boolean DEBUG = false;

    public static void enterContext() {
        Context ctx = new Context();
        contexts.push(ctx);
    }

    public static void exitContext() {
        Context toLeave;
        lastLeavedContext = toLeave = contexts.pop();
    }

    public static Context peekContext() {
        return contexts.peek();
    }

    public static Context currentContext() {
        return new Context();
    }

    public static Context makeContext(StackTraceElement[] thread) {
        return new Context(thread);
    }

    public static Context lastContext() {
        return lastLeavedContext;
    }

    public static boolean isContextChanged(Context context) {
        if (lastLeavedContext != null) {
            return !lastLeavedContext.equals(context);
        }
        return false;
    }

    public static Context getByID(String id) {
        return contextUUID.get(id);
    }

    public static class Context {
        private StackTraceElement[] stack;
        private Exception e;

        public Context() {
            this.e = new Exception();
        }

        public Context(StackTraceElement[] thread) {
            this.stack = thread;
            this.e = null;
        }

        private static int indexOf(StackTraceElement[] stack, String className) {
            return Context.indexOf(stack, className, 0, stack.length);
        }

        private static int indexOf(StackTraceElement[] stack, String className, int beginIndex, int endIndex) {
            int i = beginIndex;
            while (i < endIndex) {
                StackTraceElement element = stack[i];
                if (className.equals(element.getClassName())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private static StackTraceElement[] skipElements(StackTraceElement[] stack) {
            int num = Context.indexOf(stack, ContextManagement.class.getName());
            if (num < 0) {
                return new StackTraceElement[0];
            }
            StackTraceElement[] result = new StackTraceElement[stack.length - (num + 1)];
            System.arraycopy(stack, num + 1, result, 0, stack.length - (num + 1));
            return result;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.getStack());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return Arrays.equals(this.getStack(), other.getStack());
        }

        public String getID() {
            for (Map.Entry entry : contextUUID.entrySet()) {
                if (!this.equals(entry.getValue())) continue;
                return (String)entry.getKey();
            }
            String stateId = UUID.randomUUID().toString();
            contextUUID.put(stateId, this);
            return stateId;
        }

        public boolean isCurrent() {
            return ContextManagement.currentContext().equals(this);
        }

        public boolean contains(String clName, String methodName) {
            StackTraceElement[] stackTraceElementArray = this.getStack();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                if (e.getClassName().equals(clName) && e.getMethodName().equals(methodName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int indexOf(String clName, String methodName) {
            int index = 0;
            StackTraceElement[] stackTraceElementArray = this.getStack();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                if (e.getClassName().equals(clName) && e.getMethodName().equals(methodName)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        private StackTraceElement[] getStack() {
            if (this.stack == null && this.e != null) {
                this.stack = Context.skipElements(this.e.getStackTrace());
            }
            return this.stack;
        }

        public boolean containsClass(String clName) {
            StackTraceElement[] stackTraceElementArray = this.getStack();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                if (e.getClassName().equals(clName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean hasCall(String className, String methodName, int index) {
            StackTraceElement item = this.getStack()[index];
            return className.equals(item.getClassName()) && methodName.equals(item.getMethodName());
        }

        public StackTraceElement[] getStackTrace() {
            return this.getStack();
        }
    }
}

