/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.HashSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonViewer;

public class NestedProjectsContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    public static final String EXTENSION_ID = "org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider";
    private Command projectPresetionCommand;
    private CommonViewer viewer;

    public NestedProjectsContentProvider() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.projectPresetionCommand = commandService.getCommand("org.eclipse.ui.navigator.resources.nested.changeProjectPresentation");
        try {
            HandlerUtil.updateRadioState((Command)this.projectPresetionCommand, (String)Boolean.TRUE.toString());
        }
        catch (ExecutionException ex) {
            WorkbenchNavigatorPlugin.log(ex.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        try {
            HandlerUtil.updateRadioState((Command)this.projectPresetionCommand, (String)Boolean.FALSE.toString());
        }
        catch (ExecutionException ex) {
            WorkbenchNavigatorPlugin.log(ex.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public IProject[] getChildren(Object parentElement) {
        if (!(parentElement instanceof IContainer)) {
            return null;
        }
        IContainer container = (IContainer)parentElement;
        HashSet<IProject> nestedProjects = new HashSet<IProject>();
        IProject[] iProjectArray = container.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (container.getLocation().isPrefixOf(project.getLocation()) && project.getLocation().segmentCount() - container.getLocation().segmentCount() == 1) {
                nestedProjects.add(project);
            }
            ++n2;
        }
        return nestedProjects.toArray(new IProject[nestedProjects.size()]);
    }

    public IContainer getParent(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            if (NestedProjectManager.getInstance().isShownAsNested(project)) {
                return NestedProjectManager.getInstance().getMostDirectOpenContainer(project);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        IProject[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta().getKind() == 4 && event.getDelta().getResource().getType() == 8) {
            final HashSet<IContainer> parentsToRefresh = new HashSet<IContainer>();
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource().getType() == 4 && delta.getKind() == 1) {
                    IProject newProject = (IProject)delta.getResource();
                    if (NestedProjectManager.getInstance().isShownAsNested(newProject)) {
                        parentsToRefresh.add(this.getParent(newProject));
                    }
                }
                ++n2;
            }
            if (!parentsToRefresh.isEmpty()) {
                this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IContainer parent : parentsToRefresh) {
                            NestedProjectsContentProvider.this.viewer.refresh((Object)parent);
                        }
                    }
                });
            }
        }
    }
}

