/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.ecl.impl.rap.ServiceUtil;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.Wrapper;
import org.eclipse.rcptt.tesla.ecl.rap.model.MatchBinary;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.FileSystemResolver;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.PrefixScheme;
import org.eclipse.rcptt.util.StringUtils;

public class MatchBinaryService
implements ICommandService {
    private FileSystemResolver resolver = MatchBinaryService.makeResolver();

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        byte[] value;
        TeslaBridge.waitDelay();
        MatchBinary match = (MatchBinary)command;
        try {
            value = this.getValue(match);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.rcptt.tesla.ecl.impl.rap", "Invalid command", (Throwable)e);
        }
        if (match.getInput() instanceof Wrapper) {
            boolean result = this.matching((Wrapper)match.getInput(), value);
            context.getOutput().write((Object)ServiceUtil.wrap(result));
        }
        return Status.OK_STATUS;
    }

    private boolean matching(Wrapper wrapper, byte[] bytes) {
        Object object = wrapper.getObject();
        if (object instanceof String) {
            object = Base64.decode((String)object.toString());
        }
        if (object instanceof byte[]) {
            return Arrays.equals(bytes, (byte[])wrapper.getObject());
        }
        return false;
    }

    private byte[] getValue(MatchBinary command) throws CoreException, IOException {
        if (!StringUtils.isEmpty((String)command.getBase64())) {
            return Base64.decode((String)command.getBase64());
        }
        String path = this.getPath(command.getFilePath());
        File file = this.getFile(path);
        return FileUtil.getContents((File)file);
    }

    private String getPath(String path) throws CoreException {
        if (StringUtils.isEmpty((String)path)) {
            throw new CoreException(TeslaImplPlugin.error("The path to file is empty"));
        }
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path, true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new CoreException(TeslaImplPlugin.error("Invalid path to file."));
        }
        path = this.resolver.resolve(path);
        if (StringUtils.isEmpty((String)path)) {
            throw new CoreException(TeslaImplPlugin.error("The path is not resolved."));
        }
        return path;
    }

    private File getFile(String path) throws CoreException {
        File file = new File(path);
        if (!file.exists()) {
            throw new CoreException(TeslaImplPlugin.error("The file does not exist."));
        }
        if (!file.isFile()) {
            throw new CoreException(TeslaImplPlugin.error("It is not a file path."));
        }
        return file;
    }

    private static FileSystemResolver makeResolver() {
        File file;
        URL url;
        FileSystemResolver resolver = new FileSystemResolver();
        Location location = Platform.getInstanceLocation();
        if (location != null && (url = location.getURL()) != null) {
            try {
                file = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("workspace://", file.toString()));
            }
            catch (Exception exception) {}
        }
        if ((location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null) {
            try {
                file = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("aut://", file.toString()));
            }
            catch (Exception exception) {}
        }
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("file://", null));
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("home://", new File(System.getProperty("user.home")).getAbsolutePath()));
        return resolver;
    }
}

