/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.TestResult;

public class ResultsHandler {
    public List<TestResult> results = new ArrayList<TestResult>();
    private Multiset<AutThread> timeoutCount = HashMultiset.create();
    private Multiset<AutThread> retryCount = HashMultiset.create();
    private RunnerConfiguration conf;
    private final boolean autRestartOnFailures;
    private static final Set<String> RETRY_REASONS = ImmutableSet.of((Object)"Connection reset", (Object)"Failed to close report node");

    public ResultsHandler(RunnerConfiguration conf, boolean restartAUTOnFailures) {
        this.conf = conf;
        this.autRestartOnFailures = restartAUTOnFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompleted(TestResult result, AutThread thread) throws CoreException, InterruptedException {
        List<TestResult> list = this.results;
        synchronized (list) {
            if (RETRY_REASONS.contains(result.reason) && this.retryCount.count((Object)thread) < this.conf.connectionResetRetry) {
                thread.retry();
                this.retryCount.add((Object)thread);
                ResultsHandler.log(String.format("\nRetry %d of %d\n", this.retryCount.count((Object)thread), this.conf.connectionResetRetry), null);
                thread.restart();
                return;
            }
            this.retryCount.setCount((Object)thread, 0);
            this.results.add(result.withAdditionalInfo(this.conf, thread));
            if (result.timeout) {
                this.timeoutCount.add((Object)thread);
            } else {
                this.timeoutCount.setCount((Object)thread, 0);
            }
        }
        if (result.connectionUnavailable) {
            ResultsHandler.restartAutWithMessage(thread, "Connection to AUT is not available.");
        } else if (this.autRestartOnFailures && result.failed) {
            ResultsHandler.restartAutWithMessage(thread, "Test is failed and restartAUTOnFailure=true test option is specified.");
        } else if (this.timeoutCount.count((Object)thread) >= this.conf.timeoutRestart) {
            int tc = this.timeoutCount.count((Object)thread);
            this.timeoutCount.setCount((Object)thread, 0);
            ResultsHandler.restartAutWithMessage(thread, "Possible AUT hang detected, " + tc + " tests are failed because of timeout.");
        }
    }

    private static void restartAutWithMessage(AutThread thread, String msg) throws CoreException, InterruptedException {
        ResultsHandler.log("\n\n" + msg + " Restarting AUT.\n\n", null);
        thread.restart();
    }

    static void log(String msg, Throwable e) {
        HeadlessRunnerPlugin.getDefault().info(msg, e);
        System.out.println(msg);
    }
}

