/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.forms.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.rcptt.forms.impl.internal.Plugin;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollectingSession;
import org.eclipse.rcptt.tesla.internal.ui.player.FormTextLinkUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.IChildrenCollectingExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;

public class EclipseFormsPlayerExtension
extends AbstractSWTUIPlayerExtension {
    public SWTUIElement wrap(Object s, SWTUIPlayer player) {
        if (s instanceof IHyperlinkSegment) {
            return new FormTextLinkUIElement(null, (Object)((IHyperlinkSegment)s), player);
        }
        return null;
    }

    public GenericElementKind getKind(Object w) {
        if (w instanceof IHyperlinkSegment) {
            return new GenericElementKind(ElementKind.Link);
        }
        if (w instanceof Hyperlink) {
            return new GenericElementKind(ElementKind.Link);
        }
        if (w instanceof AbstractHyperlink) {
            return new GenericElementKind(ElementKind.Link);
        }
        if (w instanceof ExpandableComposite) {
            return new GenericElementKind(ElementKind.Expandable);
        }
        return null;
    }

    public SWTUIElement select(SWTUIPlayer player, PlayerSelectionFilter filter) {
        SWTUIElement result = null;
        switch (filter.kind.kind) {
            case Expandable: {
                result = this.searchExpandable(player, filter);
                break;
            }
            case Link: {
                result = this.searchLink(player, filter);
                break;
            }
            case FormText: {
                result = this.searchFormText(player, filter);
                break;
            }
        }
        return result;
    }

    public Widget getIndirectParent(Widget widget) {
        if (widget instanceof Hyperlink) {
            return ((Hyperlink)widget).getParent();
        }
        if (widget instanceof AbstractHyperlink) {
            return ((AbstractHyperlink)widget).getParent();
        }
        if (widget instanceof ExpandableComposite) {
            return ((ExpandableComposite)widget).getParent();
        }
        return super.getIndirectParent(widget);
    }

    public Class<?> getSearchableClass(Object widget) {
        if (widget instanceof AbstractHyperlink) {
            return AbstractHyperlink.class;
        }
        if (widget instanceof ExpandableComposite) {
            return ExpandableComposite.class;
        }
        return null;
    }

    public boolean canClick(SWTUIElement widget, boolean isDefault, boolean doubleClick, boolean arrow) {
        switch (widget.getKind().kind) {
            case FormText: {
                return true;
            }
            case Expandable: {
                return true;
            }
            case Link: {
                if (widget instanceof FormTextLinkUIElement) {
                    return true;
                }
                if (!(PlayerWrapUtils.unwrap((SWTUIElement)widget) instanceof IHyperlinkSegment)) break;
                return true;
            }
        }
        return false;
    }

    public void click(SWTUIElement widget, boolean isDefault, boolean doubleClick, boolean arrow) {
        switch (widget.getKind().kind) {
            case FormText: {
                this.clickToFormText(widget);
                break;
            }
            case Expandable: {
                this.clickToExpandable(widget);
                break;
            }
            case Link: {
                if (!(widget instanceof FormTextLinkUIElement) && !(PlayerWrapUtils.unwrap((SWTUIElement)widget) instanceof IHyperlinkSegment)) break;
                this.clickFormTextLinkUIElement(widget);
                break;
            }
        }
    }

    public static FormTextModel getFormTextModel(Canvas fText) {
        FormTextModel model = null;
        try {
            Field field = FormText.class.getDeclaredField("model");
            field.setAccessible(true);
            model = (FormTextModel)field.get(fText);
        }
        catch (Throwable e) {
            Plugin.UTILS.log(Plugin.UTILS.createError(e));
        }
        return model;
    }

    private void clickFormTextLinkUIElement(SWTUIElement widget) {
        IHyperlinkSegment segment = (IHyperlinkSegment)PlayerWrapUtils.unwrap((SWTUIElement)widget);
        FormText fText = (FormText)((FormTextLinkUIElement)widget).widget;
        FormTextModel model = EclipseFormsPlayerExtension.getFormTextModel((Canvas)fText);
        if (model.getHyperlinkCount() < 1) {
            return;
        }
        model.selectLink(segment);
        this.callActivateSelectLink((Canvas)fText);
    }

    private void clickToExpandable(SWTUIElement widget) {
        ExpandableComposite ec = (ExpandableComposite)PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        boolean newState = !ec.isExpanded();
        TeslaSWTAccess.callMethod(ExpandableComposite.class, (Object)ec, (String)"fireExpanding", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{newState, true});
        ec.setExpanded(newState);
        TeslaSWTAccess.callMethod(ExpandableComposite.class, (Object)ec, (String)"fireExpanding", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{newState, false});
        if (newState) {
            FormUtil.ensureVisible((Control)ec);
        }
    }

    private void clickToFormText(SWTUIElement widget) {
        FormText fText = (FormText)PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        FormTextModel model = EclipseFormsPlayerExtension.getFormTextModel((Canvas)fText);
        if (model.getHyperlinkCount() < 1) {
            return;
        }
        model.selectLink(model.getHyperlink(0));
        this.callActivateSelectLink((Canvas)fText);
    }

    private SWTUIElement searchExpandable(SWTUIPlayer player, PlayerSelectionFilter filter) {
        return player.selectWidget(filter, new Class[]{ExpandableComposite.class});
    }

    private SWTUIElement searchLink(SWTUIPlayer player, PlayerSelectionFilter filter) {
        return player.selectWidget(filter, new Class[]{Link.class, IHyperlinkSegment.class, AbstractHyperlink.class});
    }

    private SWTUIElement searchFormText(SWTUIPlayer swtuiPlayer, PlayerSelectionFilter filter) {
        return swtuiPlayer.selectWidget(filter, new Class[]{FormText.class});
    }

    private void callActivateSelectLink(Canvas fText) {
        try {
            Method selectlink = FormText.class.getDeclaredMethod("activateSelectedLink", new Class[0]);
            selectlink.setAccessible(true);
            selectlink.invoke((Object)fText, new Object[0]);
        }
        catch (Throwable e) {
            Plugin.UTILS.log(Plugin.UTILS.createError(e));
        }
    }

    public String getRawText(SWTUIElement element) {
        Object widget = PlayerWrapUtils.unwrap((SWTUIElement)element);
        if (widget instanceof IHyperlinkSegment) {
            return ((IHyperlinkSegment)widget).getText();
        }
        if (widget instanceof ExpandableComposite) {
            return ((ExpandableComposite)widget).getText();
        }
        if (widget instanceof Hyperlink) {
            return ((Hyperlink)widget).getText();
        }
        if (widget instanceof FormText) {
            FormText fText = (FormText)widget;
            FormTextModel model = EclipseFormsPlayerExtension.getFormTextModel((Canvas)fText);
            return model.getAccessibleText();
        }
        return null;
    }

    public IChildrenCollectingExtension getChildrenCollectingExtension(final ChildrenCollectingSession session) {
        return new IChildrenCollectingExtension(){

            public void collect() {
                if (session.w == null) {
                    return;
                }
                Widget widget = PlayerWrapUtils.unwrapWidget((SWTUIElement)session.w);
                if (widget instanceof FormText) {
                    FormText fText = (FormText)widget;
                    FormTextModel model = EclipseFormsPlayerExtension.getFormTextModel((Canvas)fText);
                    if (PlayerWidgetUtils.isVisible((Control)fText)) {
                        int i = 0;
                        while (i < model.getHyperlinkCount()) {
                            FormTextLinkUIElement wrap = new FormTextLinkUIElement((Control)fText, (Object)model.getHyperlink(i), session.player);
                            session.addItem((SWTUIElement)wrap);
                            ++i;
                        }
                    }
                }
            }
        };
    }
}

