/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.ScenarioRunnable;
import org.eclipse.rcptt.runner.util.AutLaunchFail;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.TargetPlatformChecker;

public class AUTsManager {
    final List<AutThread> autThreads = new ArrayList<AutThread>();
    final AtomicInteger autCounter = new AtomicInteger(0);
    private final RunnerConfiguration conf;
    private final TargetPlatformChecker tpc;
    private Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            try {
                AUTsManager.this.shutdownAUTs();
            }
            catch (CoreException e) {
                HeadlessRunnerPlugin.log(e.getStatus());
            }
        }
    };
    private static final String VM_INSTALL_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    private String autVM = null;

    public AUTsManager(RunnerConfiguration conf, TargetPlatformChecker tpc) {
        this.conf = conf;
        this.tpc = tpc;
        if (conf.shudownListenerPort > 0) {
            this.createShutdownListener(conf.shudownListenerPort);
        }
    }

    public boolean isClean() {
        return this.autThreads.isEmpty();
    }

    public void launchAutsAndStartTheirThreads(List<ScenarioRunnable> runnables) throws AutLaunchFail {
        int i = 0;
        while (i < this.conf.autCount) {
            if (runnables.isEmpty()) break;
            AutThread t = new AutThread(runnables, this, this.conf, this.tpc);
            int a = 0;
            while (true) {
                try {
                    t.launchAut();
                }
                catch (RuntimeException e) {
                    if (a > 10) {
                        throw new AutLaunchFail("AUT launch failed after 10 tries.", e);
                    }
                    System.out.println("Failed to launch AUT:" + e.getMessage());
                    HeadlessRunnerPlugin.getDefault().info("Failed to launch AUT:" + e.getMessage());
                    ++a;
                    continue;
                }
                break;
            }
            this.autThreads.add(t);
            ++i;
        }
        for (AutThread t : this.autThreads) {
            t.start();
        }
    }

    public void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    private void createShutdownListener(final int port) {
        new Thread(){

            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(port);
                    serverSocket.accept();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    AUTsManager.this.shutdownAUTs();
                }
                catch (CoreException e) {
                    HeadlessRunnerPlugin.log(e.getStatus());
                }
                Runtime.getRuntime().exit(0);
            }
        }.start();
    }

    void shutdownAUTs() throws CoreException {
        System.out.println("Process terminated. Shut down AUTs");
        MultiStatus status = new MultiStatus("org.eclipse.rcptt.runner", 0, "Failed to shutdown AUTs", null);
        for (AutThread thread : this.autThreads) {
            try {
                thread.shutdown();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                status.add((IStatus)new MultiStatus("org.eclipse.rcptt.runner", 0, new IStatus[]{e.getStatus()}, "Aut " + thread, null));
            }
        }
        this.autThreads.clear();
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public String getAutVm() {
        if (this.autVM != null) {
            return this.autVM;
        }
        int i = 0;
        block2: while (i < 5) {
            try {
                IVMInstallType[] types;
                this.autVM = "aut_vm_" + System.currentTimeMillis() + new Random().nextInt();
                IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IVMInstall[] vmInstalls;
                    IVMInstallType ivmInstallType = iVMInstallTypeArray[n2];
                    IVMInstall[] iVMInstallArray = vmInstalls = ivmInstallType.getVMInstalls();
                    int n3 = vmInstalls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVMInstall ivmInstall = iVMInstallArray[n4];
                        ivmInstallType.disposeVMInstall(ivmInstall.getId());
                        ++n4;
                    }
                    if (ivmInstallType.getId().equals(VM_INSTALL_TYPE)) {
                        IVMInstall install = ivmInstallType.createVMInstall(this.autVM);
                        install.setInstallLocation(new File(this.conf.javaVM));
                        install.setName(this.autVM);
                        JavaRuntime.saveVMConfiguration();
                        break block2;
                    }
                    ++n2;
                }
                break;
            }
            catch (Throwable e) {
                HeadlessRunnerPlugin.getDefault().info(e.getMessage());
                ++i;
            }
        }
        return this.autVM;
    }

    public String addJvmFromIniFile() {
        String vmFromIni = this.tpc.getTargetPlatform().getVmFromIniFile();
        if (vmFromIni == null) {
            return null;
        }
        System.out.println("Trying to use VM from application's ini file: " + vmFromIni);
        File file = new File(vmFromIni);
        if (!file.isAbsolute()) {
            file = new File(new File(this.conf.location), vmFromIni);
        }
        if (!file.exists()) {
            System.out.println("Java VM executable from ini file does not exist");
            return null;
        }
        if (!"bin".equals(file.getParentFile().getName())) {
            System.out.println("Unknown file system layout of Java VM from ini file");
            return null;
        }
        if ((file = file.getParentFile().getParentFile()) == null) {
            System.out.println("Unknown file system layout of Java VM from ini file");
            return null;
        }
        IVMInstallType type = JavaRuntime.getVMInstallType((String)VM_INSTALL_TYPE);
        if (type == null) {
            System.out.println("Error configuring Java VM from ini file - StandardVMType does not exist");
            System.out.println("Available types are:");
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType vmtype = iVMInstallTypeArray[n2];
                System.out.println(vmtype.getId());
                ++n2;
            }
        }
        String vmName = String.format("%s-jre", new File(this.conf.location).getName());
        type.disposeVMInstall(vmName);
        IVMInstall install = type.createVMInstall(vmName);
        install.setInstallLocation(file);
        install.setName(vmName);
        try {
            JavaRuntime.saveVMConfiguration();
        }
        catch (CoreException e) {
            System.out.println("Error configuring Java VM from ini file");
            e.printStackTrace();
            return null;
        }
        return String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", VM_INSTALL_TYPE, vmName);
    }
}

