/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.runtime.ui.AutEventManager;
import org.eclipse.rcptt.runtime.ui.Q7ServerStarter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Q7RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label eclInfoLabel;
    private Label teslaInfoLabel;
    private Button startButton;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.eclInfoLabel = new Label(composite, 0);
        this.eclInfoLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        this.teslaInfoLabel = new Label(composite, 0);
        this.teslaInfoLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        this.startButton = new Button(composite, 8);
        this.startButton.setText("Start servers");
        this.startButton.setLayoutData((Object)new GridData(-1, -1, true, false, 3, 1));
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    try {
                        Q7ServerStarter.INSTANCE.start();
                        AutEventManager.getInstance().sendStartup();
                    }
                    catch (Exception ee) {
                        AutEventManager.getInstance().sendInitialStartupFail("Couldn't start Q7 servers. Cause:" + ee.getMessage());
                    }
                }
                finally {
                    Q7RuntimePreferencePage.this.updateInfo();
                }
            }
        });
        this.updateInfo();
        return composite;
    }

    private void updateInfo() {
        this.init(this.eclInfoLabel, "ECL server", Q7ServerStarter.INSTANCE.getEclPort());
        this.init(this.teslaInfoLabel, "Tesla server", Q7ServerStarter.INSTANCE.getTeslaPort());
        this.startButton.setEnabled(!Q7ServerStarter.INSTANCE.isActive());
    }

    private void init(Label label, String prefix, int port) {
        if (port > 0) {
            label.setText(prefix + ": active on port " + Integer.toString(port));
        } else {
            label.setText(prefix + ": not active");
        }
    }

    public void init(IWorkbench workbench) {
    }
}

