/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.xcos.traceability.visitor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;
import org.polarsys.reqcycle.xcos.model.XcosElement;
import org.polarsys.reqcycle.xcos.model.XcosTrace;
import org.polarsys.reqcycle.xcos.traceability.types.XcosTTypeProvider;

public class XcosTraceabilityVisitor
implements IVisitor {
    @Inject
    IReachableCreator creator;

    public void start(IAdaptable adaptable) {
    }

    public boolean visit(Object o, IAdaptable adaptable) {
        XcosElement xce;
        ITraceabilityBuilder.IBuilderCallBack callBack = (ITraceabilityBuilder.IBuilderCallBack)adaptable.getAdapter(ITraceabilityBuilder.IBuilderCallBack.class);
        if (o instanceof XcosElement && (xce = (XcosElement)o) instanceof XcosTrace) {
            XcosTrace trace = (XcosTrace)xce;
            this.computeTraceability(trace, callBack);
        }
        return true;
    }

    public void end(IAdaptable adaptable) {
    }

    private void computeTraceability(XcosTrace link, ITraceabilityBuilder.IBuilderCallBack callBack) {
        TType tType = XcosTTypeProvider.get(link.getSemantics());
        Reachable target = null;
        try {
            URI uri = new URI(link.getRef());
            target = this.creator.getReachable(uri);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        if (target != null) {
            callBack.newUpwardRelation((Object)link, (Object)link.getResource(), (Object)link.getSource(), Collections.singletonList(target), tType);
        }
    }
}

