/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.IconRegistry;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.NewConfigurationDialog;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public abstract class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected ITypesManager typesManager = (ITypesManager)ZigguratInject.make(ITypesManager.class);
    protected ITypesConfigurationProvider provider = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);
    protected TypeConfigContainer container;
    protected TreeViewer treeViewer;
    protected Label labelProperties;
    protected ComposedAdapterFactory factory;
    protected Button btnAdd;
    protected Button btnRemove;
    private Tree tree;

    public AbstractPreferencePage() {
    }

    public AbstractPreferencePage(String title) {
        super(title);
    }

    public AbstractPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Composite composite = new Composite(top, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(composite, 2048);
        this.tree = this.treeViewer.getTree();
        FormData fd_tree = new FormData();
        fd_tree.bottom = new FormAttachment(75);
        fd_tree.right = new FormAttachment(100);
        fd_tree.top = new FormAttachment(0, 5);
        fd_tree.left = new FormAttachment(0, 5);
        this.tree.setLayoutData((Object)fd_tree);
        this.addProperties(composite);
        Composite composite_1 = new Composite(top, 0);
        composite_1.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        this.btnAdd = new Button(composite_1, 0);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferencePage.this.addAction();
            }
        });
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnAdd.setText(this.getAddLabel());
        this.btnRemove = new Button(composite_1, 0);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferencePage.this.removeAction();
            }
        });
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRemove.setText("Remove");
        this.addDefaultButton(composite_1);
        this.factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.treeViewer.addFilter(this.getFilter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractPreferencePage.this.selectionChanged(event);
            }
        });
        this.doLoad();
        ILabelProvider labelProvider = this.getLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setComparator(new ViewerComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                return Ordering.natural().compare((Object)s1, (Object)s2);
            }
        }));
        this.treeViewer.setContentProvider(this.getContentProvider());
        this.setInput();
        return top;
    }

    protected IContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)this.factory);
    }

    protected ILabelProvider getLabelProvider() {
        return new AdapterFactoryLabelProvider((AdapterFactory)this.factory){

            public Image getImage(Object object) {
                Relation relation;
                String icon;
                if (object instanceof Relation && (icon = (relation = (Relation)object).getIcon()) != null && icon.length() > 0) {
                    return IconRegistry.getImage(icon);
                }
                return super.getImage(object);
            }
        };
    }

    protected abstract void removeAction();

    protected void addProperties(Composite composite) {
        Group grpProperties = new Group(composite, 0);
        FormData fd_grpProperties = new FormData();
        fd_grpProperties.top = new FormAttachment((Control)this.tree, 5);
        fd_grpProperties.bottom = new FormAttachment(100, 5);
        fd_grpProperties.right = new FormAttachment(100);
        fd_grpProperties.left = new FormAttachment(0, 5);
        grpProperties.setLayoutData((Object)fd_grpProperties);
        grpProperties.setLayout((Layout)new GridLayout(2, false));
        grpProperties.setText("Properties");
        this.labelProperties = new Label((Composite)grpProperties, 64);
        this.labelProperties.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    protected String getAddLabel() {
        return "Add";
    }

    protected abstract void addAction();

    protected abstract boolean removeCondition(EObject var1);

    protected void addDefaultButton(Composite composite_1) {
        Button defaultButton = new Button(composite_1, 0);
        defaultButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        defaultButton.setText("set current");
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection new_name;
                if (AbstractPreferencePage.this.treeViewer.getSelection() instanceof IStructuredSelection && (new_name = (IStructuredSelection)AbstractPreferencePage.this.treeViewer.getSelection()).getFirstElement() instanceof Configuration) {
                    Configuration conf = (Configuration)new_name.getFirstElement();
                    if (conf.getParent().getDefaultConfiguration() == conf) {
                        conf.getParent().setDefaultConfiguration(null);
                    } else {
                        conf.getParent().setDefaultConfiguration(conf);
                    }
                    AbstractPreferencePage.this.treeViewer.refresh();
                }
            }
        });
    }

    protected abstract ViewerFilter getFilter();

    protected void displayProperties(EObject eobject) {
        if (eobject == null) {
            this.labelProperties.setText("");
        } else {
            StringBuffer buffer = new StringBuffer();
            ILabelProvider labelProvider = this.getLabelProvider();
            for (EStructuralFeature f : eobject.eClass().getEAllStructuralFeatures()) {
                if (f instanceof EReference && ((EReference)f).isContainment()) continue;
                buffer.append(f.getName()).append(" : ");
                buffer.append(this.getText(eobject, labelProvider, f));
                buffer.append("\n");
            }
            this.labelProperties.setText(buffer.toString());
        }
    }

    private String getText(EObject eobject, final ILabelProvider labelProvider, EStructuralFeature f) {
        Object eGet = eobject.eGet(f);
        if (eGet instanceof Collection) {
            Collection collec = (Collection)eGet;
            return Joiner.on((String)", ").join(Iterables.transform((Iterable)collec, (Function)new Function<Object, String>(){

                public String apply(Object o) {
                    return labelProvider.getText(o);
                }
            }));
        }
        return labelProvider.getText(eGet);
    }

    protected void createConfiguration() {
        NewConfigurationDialog dialog = new NewConfigurationDialog(this.getShell());
        if (dialog.open() == 0) {
            this.container.getConfigurations().add((Object)dialog.getConfiguration());
            this.treeViewer.refresh();
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        this.doLoad();
        super.performDefaults();
    }

    protected void doLoad() {
        this.container = this.provider.getContainer();
        if (this.container.eResource() == null) {
            Resource r = new ResourceSetImpl().createResource(URI.createURI((String)"dummy://dummy"));
            r.getContents().add((Object)this.container);
        }
    }

    protected void setInput() {
        this.treeViewer.setInput((Object)this.container.eResource());
    }

    protected void performApply() {
        super.performApply();
        this.performOk();
        this.doLoad();
        this.setInput();
    }

    public boolean performOk() {
        if (this.container != null) {
            this.provider.save((EObject)this.container);
        }
        return super.performOk();
    }

    protected void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)event.getSelection();
            Object firstElement = structured.getFirstElement();
            if (firstElement instanceof EObject) {
                EObject eobject = (EObject)firstElement;
                this.displayProperties(eobject);
                this.btnRemove.setEnabled(this.removeCondition(eobject));
            } else {
                this.displayProperties(null);
            }
        } else {
            this.displayProperties(null);
        }
    }
}

