/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.jdt.utils;

import com.google.common.base.Joiner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.polarsys.reqcycle.jdt.model.JDTReachableObject;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.NullReachableObject;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class JDTUtils {
    public static final String PLATFORM = "platform:";
    public static final String SEPARATOR = "::";
    private static IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);

    public static ReachableObject getReachable(IFile cu) {
        if ("java".equalsIgnoreCase(cu.getFileExtension())) {
            try {
                JDTReachableObject jdtReachableObject = new JDTReachableObject(creator.getReachable(new URI(PLATFORM + cu.getFullPath().toString()), (Object)cu));
                ZigguratInject.inject((Object[])new Object[]{jdtReachableObject});
                return jdtReachableObject;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static ReachableObject getReachable(IJavaElement cu) {
        try {
            if (cu == null) {
                return new NullReachableObject();
            }
            String qualifiedURI = JDTUtils.getQualifiedURI(cu);
            if (qualifiedURI == null) {
                return new NullReachableObject();
            }
            URI uri = new URI(qualifiedURI);
            JDTReachableObject object = new JDTReachableObject(creator.getReachable(uri, (Object)cu));
            ZigguratInject.inject((Object[])new Object[]{object});
            return object;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getQualifiedURI(IJavaElement element) {
        StringBuilder result = new StringBuilder();
        if (element == null || element.getResource() == null) {
            return null;
        }
        result.append(PLATFORM).append(element.getResource().getFullPath().toString()).append("#");
        LinkedList<String> names = new LinkedList<String>();
        names.add(element.getElementName());
        IJavaElement parent = element.getParent();
        while (parent != null && !(parent instanceof ICompilationUnit)) {
            names.add(0, parent.getElementName());
            parent = parent.getParent();
        }
        result.append(Joiner.on((String)SEPARATOR).join(names));
        return result.toString();
    }
}

