/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.providers;

import javax.inject.Inject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.ui.providers.PredicatesItemProviderAdapterFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.CaseStyle;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.ui.dialogs.IconRegistry;
import org.polarsys.reqcycle.styling.ui.providers.StylingLabelProvider;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class BasicStylingLabelProvider
extends StylingLabelProvider {
    @Inject
    IStylingManager manager;

    public BasicStylingLabelProvider() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    @Override
    public Image getImage(Object object) {
        if (object instanceof RequirementSource) {
            return null;
        }
        if (object instanceof IPredicate) {
            PredicatesItemProviderAdapterFactory factory = new PredicatesItemProviderAdapterFactory();
            return new AdapterFactoryLabelProvider((AdapterFactory)factory).getImage(object);
        }
        StylingModel model = this.getStylingModel();
        if (model != null && model.getBasic() != null && model.getBasic().getIcon() != null) {
            return IconRegistry.getImage(model.getBasic().getIcon().getImage());
        }
        return null;
    }

    @Override
    public <T> T getText(Object element, Class<T> theClass) {
        String label;
        EObject eobject;
        if (element instanceof EObject && !this.containsAdapter(eobject = (EObject)element)) {
            eobject.eAdapters().add((Object)new StylingLabelProvider.StylingAdapter(this));
        }
        if (element instanceof RequirementsContainer) {
            label = "Requirements container";
            return this.toT(label, theClass);
        }
        if (element instanceof RequirementSource) {
            label = ((RequirementSource)element).getRepositoryURI();
            label = label == null ? ((RequirementSource)element).getName() : String.valueOf(((RequirementSource)element).getName()) + " [" + label + "]";
            return this.toT(label, theClass);
        }
        StylingModel model = this.getStylingModel();
        if (model != null && model.getBasic() != null) {
            if (StyledString.class.equals(theClass)) {
                return (T)this.applyStyle(element, (CaseStyle)model.getBasic());
            }
            StyledString s = this.applyStyle(element, (CaseStyle)model.getBasic());
            return (T)s.getString();
        }
        return this.getDefaultText(element, theClass);
    }
}

