/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.engine.impl;

import java.util.Iterator;
import javax.inject.Inject;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Filter;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.engine.ITypedTraceabilityEngine;
import org.polarsys.reqcycle.traceability.types.engine.functions.Configuration2Filter;
import org.polarsys.reqcycle.uri.model.Reachable;

public class TypedTraceabilityEngine
implements ITypedTraceabilityEngine {
    @Inject
    ITraceabilityEngine engine;

    @Override
    public Iterator<Pair<Link, Reachable>> getTraceability(Configuration typeConfig, Request ... requests) throws EngineException {
        if (typeConfig != null) {
            Request[] requestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                Request r = requestArray[n2];
                this.handleFilter(typeConfig, r);
                ++n2;
            }
        }
        return this.engine.getTraceability(requests);
    }

    private void handleFilter(Configuration typeConfig, Request r) {
        Filter confFilter = new Configuration2Filter(r.getDirection()).apply(typeConfig);
        r.setFilter((Filter)new AndFilter(r.getFilter(), confFilter));
    }

    public Iterator<Pair<Link, Reachable>> getTraceability(Request ... requests) throws EngineException {
        return this.getTraceability((Configuration)null, requests);
    }

    private class AndFilter
    implements Filter {
        private Filter[] filters;

        public AndFilter(Filter ... f) {
            this.filters = f;
        }

        public boolean apply(Pair<Link, Reachable> pair) {
            boolean result = true;
            Filter[] filterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                Filter f = filterArray[n2];
                if (f != null) {
                    result &= f.apply(pair);
                }
                ++n2;
            }
            return result;
        }
    }
}

