/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf;

import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf.ReqVoc;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.utils.SPARQLStringBuilder;

public class Queries {
    public static final String OWNER = "owner";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String LINK = "link";
    public static final String KIND = "kind";
    public static final String DIRECTION = "direction";
    public static final String EXTREMITY = "extremity";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";

    public static String buildPropertySelectQuery(Resource context) {
        SPARQLStringBuilder queryBuilder = new SPARQLStringBuilder(new StringBuilder());
        queryBuilder.prefix(ReqVoc.NS);
        queryBuilder.prefix(RDF.NS);
        queryBuilder.prefix(RDFS.NS);
        queryBuilder.select(KEY, VALUE, OWNER);
        if (context != null) {
            queryBuilder.from(context);
        }
        queryBuilder.append("WHERE {");
        queryBuilder.statement(OWNER, ReqVoc.HAS_PROPERTY, "prop");
        queryBuilder.statement("prop", RDFS.LABEL, KEY);
        queryBuilder.statement("prop", RDF.VALUE, VALUE);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    public static String buildPropertyDeleteQuery(Resource context) {
        SPARQLStringBuilder queryBuilder = new SPARQLStringBuilder(new StringBuilder());
        queryBuilder.prefix(ReqVoc.NS);
        queryBuilder.prefix(RDF.NS);
        queryBuilder.prefix(RDFS.NS);
        queryBuilder.append("DELETE ");
        if (context != null) {
            queryBuilder.from(context);
        }
        queryBuilder.append("{ ");
        queryBuilder.statement(OWNER, ReqVoc.HAS_PROPERTY, "prop");
        queryBuilder.statement("prop", RDFS.LABEL, KEY);
        queryBuilder.statement("prop", RDF.VALUE, VALUE);
        queryBuilder.append("} WHERE {");
        queryBuilder.statement(OWNER, ReqVoc.HAS_PROPERTY, "prop");
        queryBuilder.statement("prop", RDFS.LABEL, KEY);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    public static String buildLinkSelectQuery(Resource context) {
        SPARQLStringBuilder queryBuilder = new SPARQLStringBuilder(new StringBuilder());
        queryBuilder.prefix(ReqVoc.NS);
        queryBuilder.prefix(RDF.NS);
        queryBuilder.select(LINK, KIND, DIRECTION, EXTREMITY);
        if (context != null) {
            queryBuilder.from(context);
        }
        queryBuilder.append("WHERE {");
        queryBuilder.statement(LINK, RDF.TYPE, ReqVoc.TYPE_TRACEABILITY);
        queryBuilder.statement(EXTREMITY, RDF.TYPE, ReqVoc.TYPE_TRACEABLE);
        queryBuilder.statement(EXTREMITY, RDF.TYPE, ReqVoc.TYPE_TRACEABLE);
        queryBuilder.statement(LINK, ReqVoc.HAS_KIND, KIND);
        queryBuilder.statement(LINK, DIRECTION, EXTREMITY);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    public static String buildLinkSelectQuery2(Resource context) {
        SPARQLStringBuilder queryBuilder = new SPARQLStringBuilder(new StringBuilder());
        queryBuilder.prefix(ReqVoc.NS);
        queryBuilder.prefix(RDF.NS);
        queryBuilder.select(LINK, SOURCE, TARGET, KIND);
        if (context != null) {
            queryBuilder.from(context);
        }
        queryBuilder.append("WHERE {");
        queryBuilder.statement(LINK, RDF.TYPE, ReqVoc.TYPE_TRACEABILITY);
        queryBuilder.statement(SOURCE, RDF.TYPE, ReqVoc.TYPE_TRACEABLE);
        queryBuilder.statement(TARGET, RDF.TYPE, ReqVoc.TYPE_TRACEABLE);
        queryBuilder.statement(LINK, ReqVoc.HAS_KIND, KIND);
        queryBuilder.statement(LINK, ReqVoc.HAS_DOWNSTREAM, SOURCE);
        queryBuilder.statement(LINK, ReqVoc.HAS_UPSTREAM, TARGET);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    private Queries() {
    }
}

