/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Export;
import org.polarsys.reqcycle.export.pages.PredicateSelectionPage;
import org.polarsys.reqcycle.export.pages.RequirementSourceSelectionPage;
import org.polarsys.reqcycle.export.pages.WizardController;
import org.polarsys.reqcycle.export.transform.TraceabilityExport;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public abstract class AbstractExportWizard
extends Wizard
implements IExportWizard {
    protected RequirementSourceSelectionPage rssp;
    protected IWizardPage outputPage;
    protected PredicateSelectionPage predicatePage;
    protected IStructuredSelection selection;
    protected WizardController controller;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.controller = this.getController();
        this.rssp = this.getSourceSelectionPage();
        this.addPage((IWizardPage)this.rssp);
        this.outputPage = this.getOutputPage(this.controller);
        this.addPage(this.outputPage);
        this.predicatePage = new PredicateSelectionPage(this.controller);
        this.addPage((IWizardPage)this.predicatePage);
        ZigguratInject.inject((Object[])new Object[]{this.rssp, this.outputPage, this.predicatePage});
        for (Object o : selection) {
            if (!(o instanceof RequirementSource)) continue;
            RequirementSource source = (RequirementSource)o;
            this.rssp.select(source);
        }
    }

    protected RequirementSourceSelectionPage getSourceSelectionPage() {
        return new RequirementSourceSelectionPage(this.controller);
    }

    protected WizardController getController() {
        return new WizardController();
    }

    protected abstract IWizardPage getOutputPage(WizardController var1);

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Export", 10);
                        SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 9);
                        Export export = new TraceabilityExport().transform(AbstractExportWizard.this.controller.getReqResult(), AbstractExportWizard.this.controller.getPredicateResult(), AbstractExportWizard.this.controller.getProjectsResult(), AbstractExportWizard.this.isExportTraceability(), AbstractExportWizard.this.controller.getOutputPath(), (IProgressMonitor)monitor2);
                        SubProgressMonitor monitor3 = new SubProgressMonitor(monitor, 1);
                        AbstractExportWizard.this.doTransform(export, (IProgressMonitor)monitor3);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.error(e.getCause());
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            this.error(e);
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            this.error(e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void error(Throwable e) {
        if (this.getContainer().getCurrentPage() instanceof WizardPage) {
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            page.setErrorMessage(e.getMessage());
        }
    }

    protected abstract boolean isExportTraceability();

    protected abstract void doTransform(Export var1, IProgressMonitor var2) throws Exception;
}

