/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.channel;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.jms.JMSException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.comm.ISynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSChannel;
import org.eclipse.ecf.provider.jms.channel.ConnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.ECFMessage;
import org.eclipse.ecf.provider.jms.channel.JMSMessage;
import org.eclipse.ecf.provider.jms.channel.Ping;

public abstract class AbstractJMSServerChannel
extends AbstractJMSChannel
implements ISynchAsynchConnection {
    private static final long serialVersionUID = -4762123821387039176L;
    private static final int RESPOND_TO_REQUEST_ERROR_CODE = 33001;

    public AbstractJMSServerChannel(ISynchAsynchEventHandler handler, int keepAlive) {
        super(handler, keepAlive);
    }

    public Object connect(ID remote, Object data, int timeout) throws ECFException {
        throw new ECFException("Server container cannot connect");
    }

    public Client createClient(ID remoteID) {
        Client newclient = new Client(remoteID);
        newclient.start();
        return newclient;
    }

    protected void handleSynchRequest(String jmsCorrelationID, ECFMessage o) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"handleSynchRequest", (Object[])new Object[]{o});
        try {
            this.handler.handleSynchEvent(new SynchEvent((ISynchConnection)this, (Object)new Object[]{jmsCorrelationID, o}));
        }
        catch (IOException e) {
            this.traceAndLogExceptionCatch(33001, "handleSynchRequest", e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"handleSynchRequest");
    }

    public Object sendSynch(ID target, byte[] data) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendSynch", (Object[])new Object[]{target, data});
        Serializable result = null;
        if (this.isActive()) {
            result = this.sendAndWait(new DisconnectRequestMessage(this.getConnectionID(), this.getLocalID(), target, (Serializable)data), this.keepAlive);
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("sendSynch: channel not active...ignoring sendSynch to target=" + target));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendSynch", (Object)result);
        return result;
    }

    public class Client
    implements ISynchAsynchConnection {
        public static final int DEFAULT_PING_WAITTIME = 3000;
        private final Map properties;
        private final ID clientID;
        boolean isStarted = false;
        final Object disconnectLock = new Object();
        boolean disconnectHandled = false;
        private Thread pingThread = null;
        private final int pingWaitTime = 3000;
        private long lastSendTime = -1L;
        private boolean usePing = false;

        protected long getLastSendTime() {
            return this.lastSendTime;
        }

        protected void setLastSendTime() {
            this.lastSendTime = System.currentTimeMillis();
        }

        public Client(ID clientID) {
            this(clientID, true);
        }

        public Client(ID clientID, boolean usePing) {
            this.clientID = clientID;
            this.properties = new HashMap();
            this.usePing = usePing;
        }

        public void sendAsynch(ID receiver, byte[] data) throws IOException {
            this.setLastSendTime();
            AbstractJMSServerChannel.this.sendAsynch(receiver, data);
        }

        public void addListener(IConnectionListener listener) {
        }

        public Object connect(ID remote, Object data, int timeout) throws ECFException {
            throw new ECFException("Server container cannot connect");
        }

        public void disconnect() {
            this.stop();
        }

        public ID getLocalID() {
            return this.clientID;
        }

        public Map getProperties() {
            return this.properties;
        }

        public boolean isConnected() {
            return true;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public void removeListener(IConnectionListener listener) {
        }

        public void start() {
            if (!this.isStarted) {
                this.isStarted = true;
                if (this.usePing) {
                    this.pingThread = this.setupPing();
                    this.pingThread.setDaemon(true);
                    this.pingThread.start();
                }
            }
        }

        public void stop() {
            if (this.isStarted) {
                this.isStarted = false;
                if (this.pingThread != null) {
                    this.pingThread.interrupt();
                    this.pingThread = null;
                }
            }
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public Object sendSynch(ID receiver, byte[] data) throws IOException {
            return AbstractJMSServerChannel.this.sendSynch(receiver, data);
        }

        private Thread setupPing() {
            final int pingStartWait = new Random().nextInt(AbstractJMSServerChannel.this.keepAlive / 2);
            return new Thread(new Runnable(){

                public void run() {
                    Thread me = Thread.currentThread();
                    try {
                        Thread.sleep(pingStartWait);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    int frequency = ((Client)Client.this).AbstractJMSServerChannel.this.keepAlive / 2;
                    while (Client.this.isStarted) {
                        try {
                            if (me.isInterrupted() || Client.this.disconnectHandled) break;
                            Thread.sleep(frequency);
                            if (me.isInterrupted() || Client.this.disconnectHandled) break;
                            long lastSendTime1 = Client.this.getLastSendTime();
                            if (System.currentTimeMillis() <= lastSendTime1 + (long)frequency) continue;
                            Client.this.setLastSendTime();
                            AbstractJMSServerChannel.this.sendAndWait(new Ping(AbstractJMSServerChannel.this.getLocalID(), Client.this.getLocalID()), 3000);
                        }
                        catch (Exception e) {
                            Client.this.handleException(e);
                            break;
                        }
                    }
                    Client.this.handleException(null);
                }
            }, this.getLocalID() + ":ping:" + AbstractJMSServerChannel.this.getLocalID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDisconnect(String jmsCorrelationID, ID targetID, ID senderID) {
            Object object = this.disconnectLock;
            synchronized (object) {
                if (!this.disconnectHandled) {
                    this.disconnectHandled = true;
                    AbstractJMSServerChannel.this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, null, null));
                }
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            try {
                AbstractJMSServerChannel.this.createAndSendMessage(new DisconnectResponseMessage(AbstractJMSServerChannel.this.getConnectionID(), targetID, senderID, null), jmsCorrelationID);
            }
            catch (JMSException e) {
                AbstractJMSServerChannel.this.traceAndLogExceptionCatch(33001, "handleDisconnect", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleException(Throwable e) {
            Object object = this.disconnectLock;
            synchronized (object) {
                if (!this.disconnectHandled) {
                    this.disconnectHandled = true;
                    if (e != null) {
                        AbstractJMSServerChannel.this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, e, null));
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        public void handleConnect(String jmsCorrelationID, ID targetID, ID senderID, Serializable[] messages) throws JMSException {
            AbstractJMSServerChannel.this.createAndSendMessage(new ConnectResponseMessage(AbstractJMSServerChannel.this.getConnectionID(), targetID, senderID, messages == null ? null : messages[0]), jmsCorrelationID);
            AbstractJMSServerChannel.this.createAndSendMessage(new JMSMessage(AbstractJMSServerChannel.this.getConnectionID(), this.getLocalID(), null, messages == null ? null : messages[1]), null);
        }
    }
}

