/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.set;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;

public abstract class DelegatingSetProperty<S, E>
extends SetProperty<S, E> {
    private final Object elementType;
    private final ISetProperty<S, E> nullProperty = new NullSetProperty();

    protected DelegatingSetProperty() {
        this(null);
    }

    protected DelegatingSetProperty(Object elementType) {
        this.elementType = elementType;
    }

    protected final ISetProperty<S, E> getDelegate(S source) {
        if (source == null) {
            return this.nullProperty;
        }
        ISetProperty<S, E> delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract ISetProperty<S, E> doGetDelegate(S var1);

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    protected Set<E> doGetSet(S source) {
        return this.getDelegate(source).getSet(source);
    }

    @Override
    protected void doSetSet(S source, Set<E> set) {
        this.getDelegate(source).setSet(source, set);
    }

    @Override
    protected void doUpdateSet(S source, SetDiff<E> diff) {
        this.getDelegate(source).updateSet(source, diff);
    }

    @Override
    public IObservableSet<E> observe(S source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableSet<E> observe(Realm realm, S source) {
        return this.getDelegate(source).observe(realm, source);
    }

    private class NullSetProperty
    extends SimpleSetProperty<S, E> {
        private NullSetProperty() {
        }

        @Override
        public Object getElementType() {
            return DelegatingSetProperty.this.elementType;
        }

        @Override
        protected Set<E> doGetSet(S source) {
            return Collections.emptySet();
        }

        @Override
        protected void doSetSet(S source, Set<E> set, SetDiff<E> diff) {
        }

        @Override
        protected void doSetSet(S source, Set<E> set) {
        }

        @Override
        protected void doUpdateSet(S source, SetDiff<E> diff) {
        }

        @Override
        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, SetDiff<E>> listener) {
            return null;
        }
    }
}

