/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.internal.HttpServiceFactory;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ProxyServlet;
import org.eclipse.equinox.http.servlet.internal.util.HttpTuple;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<HttpServlet, HttpTuple> {
    private static final Random RANDOM = new Random();
    private static final String DEFAULT_SERVICE_DESCRIPTION = "Equinox Servlet Bridge";
    private static final String DEFAULT_SERVICE_VENDOR = "Eclipse.org";
    private static final String PROP_GLOBAL_WHITEBOARD = "equinox.http.global.whiteboard";
    public static final String UNIQUE_SERVICE_ID = "equinox.http.id";
    private static final String[] HTTP_SERVICES_CLASSES = new String[]{HttpService.class.getName(), ExtendedHttpService.class.getName()};
    private static volatile BundleContext context;
    private static ConcurrentMap<ProxyServlet, Object> registrations;
    private ServiceTracker<HttpServlet, HttpTuple> serviceTracker;

    static {
        registrations = new ConcurrentHashMap<ProxyServlet, Object>();
    }

    public static void addProxyServlet(ProxyServlet proxyServlet) {
        Object previousRegistration = registrations.putIfAbsent(proxyServlet, (Object)proxyServlet);
        BundleContext currentContext = context;
        try {
            if (!(previousRegistration instanceof ServiceRegistration) && currentContext != null) {
                ServiceRegistration serviceRegistration = currentContext.registerService(HttpServlet.class, (Object)proxyServlet, new Hashtable());
                registrations.put(proxyServlet, serviceRegistration);
            }
        }
        catch (IllegalStateException ex) {
            return;
        }
    }

    public static void unregisterHttpService(ProxyServlet proxyServlet) {
        Object registration = registrations.remove((Object)proxyServlet);
        if (registration instanceof ServiceRegistration) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)registration;
            serviceRegistration.unregister();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.processRegistrations();
        this.serviceTracker = new ServiceTracker(bundleContext, HttpServlet.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serviceTracker.close();
        this.serviceTracker = null;
        context = null;
    }

    /*
     * WARNING - void declaration
     */
    public HttpTuple addingService(ServiceReference<HttpServlet> serviceReference) {
        HttpServlet httpServlet;
        BundleContext currentContext;
        block11: {
            currentContext = context;
            if (currentContext == null) {
                return null;
            }
            httpServlet = (HttpServlet)currentContext.getService(serviceReference);
            if (httpServlet instanceof ProxyServlet) break block11;
            currentContext.ungetService(serviceReference);
            return null;
        }
        try {
            Object httpServiceEndpointObj;
            ProxyServlet proxyServlet = (ProxyServlet)httpServlet;
            ServletConfig servletConfig = proxyServlet.getServletConfig();
            ServletContext servletContext = servletConfig.getServletContext();
            Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>(3);
            Enumeration initparameterNames = servletConfig.getInitParameterNames();
            while (initparameterNames.hasMoreElements()) {
                String name = (String)initparameterNames.nextElement();
                ((Dictionary)serviceProperties).put(name, servletConfig.getInitParameter(name));
            }
            if (((Dictionary)serviceProperties).get("service.vendor") == null) {
                ((Dictionary)serviceProperties).put("service.vendor", DEFAULT_SERVICE_VENDOR);
            }
            if (((Dictionary)serviceProperties).get("service.description") == null) {
                ((Dictionary)serviceProperties).put("service.description", DEFAULT_SERVICE_DESCRIPTION);
            }
            if ((httpServiceEndpointObj = ((Dictionary)serviceProperties).get("osgi.http.endpoint")) == null) {
                httpServiceEndpoints = this.getHttpServiceEndpoints(serviceProperties, servletContext, servletConfig.getServletName());
                ((Dictionary)serviceProperties).put("osgi.http.endpoint", httpServiceEndpoints);
            } else {
                httpServiceEndpoints = new ArrayList();
                String contextPath = servletContext.getContextPath();
                for (String string : StringPlus.from(httpServiceEndpointObj)) {
                    void var12_15;
                    if (!string.startsWith("http".concat(":")) && !string.startsWith(contextPath)) {
                        String string2 = contextPath + string;
                    }
                    httpServiceEndpoints.add(var12_15);
                }
                ((Dictionary)serviceProperties).put("osgi.http.endpoint", httpServiceEndpoints);
            }
            ((Dictionary)serviceProperties).put(UNIQUE_SERVICE_ID, RANDOM.nextLong());
            boolean useSystemContext = Boolean.valueOf(currentContext.getProperty(PROP_GLOBAL_WHITEBOARD));
            BundleContext trackingContext = useSystemContext ? currentContext.getBundle("System Bundle").getBundleContext() : currentContext;
            HttpServiceRuntimeImpl httpServiceRuntimeImpl = new HttpServiceRuntimeImpl(trackingContext, currentContext, servletContext, serviceProperties);
            httpServiceRuntimeImpl.open();
            proxyServlet.setHttpServiceRuntimeImpl(httpServiceRuntimeImpl);
            HttpServiceFactory httpServiceFactory = new HttpServiceFactory(httpServiceRuntimeImpl);
            ServiceRegistration hsfRegistration = currentContext.registerService(HTTP_SERVICES_CLASSES, (Object)httpServiceFactory, serviceProperties);
            ((Dictionary)serviceProperties).put("osgi.http.service.id", Collections.singletonList(hsfRegistration.getReference().getProperty("service.id")));
            ServiceRegistration hsrRegistration = currentContext.registerService(HttpServiceRuntime.class, (Object)httpServiceRuntimeImpl, serviceProperties);
            httpServiceRuntimeImpl.setHsrRegistration((ServiceRegistration<HttpServiceRuntime>)hsrRegistration);
            return new HttpTuple(proxyServlet, httpServiceFactory, hsfRegistration, httpServiceRuntimeImpl, (ServiceRegistration<HttpServiceRuntime>)hsrRegistration);
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public void modifiedService(ServiceReference<HttpServlet> serviceReference, HttpTuple httpTuple) {
        this.removedService(serviceReference, httpTuple);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<HttpServlet> serviceReference, HttpTuple httpTuple) {
        BundleContext currentContext = context;
        if (currentContext != null) {
            try {
                currentContext.ungetService(serviceReference);
                httpTuple.destroy();
            }
            catch (IllegalStateException ex) {
                return;
            }
        }
    }

    private String[] getHttpServiceEndpoints(Dictionary<String, Object> serviceProperties, ServletContext servletContext, String servletName) {
        ArrayList<Object> httpServiceEndpoints = new ArrayList<Object>();
        String contextPath = (String)serviceProperties.get("context.path");
        if (contextPath != null) {
            String httpHost = (String)serviceProperties.get("http.host");
            String httpPort = (String)serviceProperties.get("http.port");
            if (httpPort != null) {
                if (httpHost == null) {
                    endpoint = this.assembleEndpoint("http", "localhost", httpPort, contextPath);
                    httpServiceEndpoints.add(endpoint);
                } else {
                    endpoint = this.assembleEndpoint("http", httpHost, httpPort, contextPath);
                    httpServiceEndpoints.add(endpoint);
                }
            }
            String httpsHost = (String)serviceProperties.get("https.host");
            String httpsPort = (String)serviceProperties.get("https.port");
            if (httpsPort != null) {
                if (httpsHost == null) {
                    endpoint = this.assembleEndpoint("https", "localhost", httpsPort, contextPath);
                    httpServiceEndpoints.add(endpoint);
                } else {
                    endpoint = this.assembleEndpoint("https", httpHost, httpsPort, contextPath);
                    httpServiceEndpoints.add(endpoint);
                }
            }
            if (!httpServiceEndpoints.isEmpty()) {
                return httpServiceEndpoints.toArray(new String[0]);
            }
        }
        contextPath = servletContext.getContextPath();
        ServletRegistration servletRegistration = null;
        try {
            servletRegistration = servletContext.getServletRegistration(servletName);
        }
        catch (UnsupportedOperationException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not find the servlet registration for the servlet: ");
            sb.append(servletName);
            sb.append(" The Http Service will not be able to locate it's root path.");
            sb.append(" This can be overcome by specifying an init-param with name 'osgi.http.endpoint'");
            sb.append(" and value equal to the servlet mapping minus the glob character '*'.");
            servletContext.log(sb.toString());
        }
        if (servletRegistration == null) {
            return new String[0];
        }
        Collection mappings = servletRegistration.getMappings();
        for (Object mapping : mappings) {
            if (((String)mapping).indexOf(47) != 0) continue;
            if (((String)mapping).charAt(((String)mapping).length() - 1) == '*' && ((String)(mapping = ((String)mapping).substring(0, ((String)mapping).length() - 1))).length() > 1 && ((String)mapping).charAt(((String)mapping).length() - 1) != '/') {
                mapping = (String)mapping + "/";
            }
            httpServiceEndpoints.add(contextPath + (String)mapping);
        }
        return httpServiceEndpoints.toArray(new String[0]);
    }

    private String assembleEndpoint(String protocol, String host, String port, String contextPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol);
        sb.append("://");
        sb.append(host);
        sb.append(':');
        sb.append(port);
        sb.append(contextPath);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    private void processRegistrations() {
        BundleContext currentContext = context;
        if (currentContext == null) {
            return;
        }
        for (Map.Entry entry : registrations.entrySet()) {
            ProxyServlet proxyServlet = (ProxyServlet)((Object)entry.getKey());
            Object value = entry.getValue();
            try {
                if (value instanceof ServiceRegistration) continue;
                ServiceRegistration serviceRegistration = currentContext.registerService(HttpServlet.class, (Object)proxyServlet, new Hashtable());
                entry.setValue(serviceRegistration);
            }
            catch (IllegalStateException ex) {
                return;
            }
        }
    }
}

