/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Server server = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    protected ArrayList<Executor> executors = new ArrayList();
    protected Container container = null;
    private ClassLoader parentClassLoader = null;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.getState().isAvailable() && this.container != null) {
            try {
                this.container.start();
            }
            catch (LifecycleException lifecycleException) {}
        }
        if (this.getState().isAvailable() && oldContainer != null) {
            try {
                oldContainer.stop();
            }
            catch (LifecycleException lifecycleException) {}
        }
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException e) {
                    log.error(sm.getString("standardService.connector.startFailed", connector), e);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        int i = 0;
        while (i < results.length) {
            results[i] = this.connectors[i].getObjectName();
            ++i;
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int j = -1;
            int i = 0;
            while (i < this.connectors.length) {
                if (connector == this.connectors[i]) {
                    j = i;
                    break;
                }
                ++i;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.connectors[j].getState().isAvailable()) {
                try {
                    this.connectors[j].stop();
                }
                catch (LifecycleException e) {
                    log.error(sm.getString("standardService.connector.stopFailed", this.connectors[j]), e);
                }
            }
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (i2 != j) {
                    results[k++] = this.connectors[i2];
                }
                ++i2;
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.getState().isAvailable()) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x) {
                        log.error("Executor.start", x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String executorName) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                if (!executorName.equals(executor.getName())) continue;
                return executor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.getState().isAvailable()) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e) {
                    log.error("Executor.stop", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        Connector[] connectorArray;
        if (log.isInfoEnabled()) {
            log.info(sm.getString("standardService.start.name", this.name));
        }
        this.setState(LifecycleState.STARTING);
        if (this.container != null) {
            connectorArray = this.container;
            synchronized (connectorArray) {
                this.container.start();
            }
        }
        connectorArray = this.executors;
        synchronized (connectorArray) {
            for (Executor executor : this.executors) {
                executor.start();
            }
        }
        connectorArray = this.connectors;
        synchronized (this.connectors) {
            Connector[] connectorArray2 = this.connectors;
            int n = this.connectors.length;
            int n2 = 0;
            while (n2 < n) {
                Connector connector = connectorArray2[n2];
                try {
                    if (connector.getState() != LifecycleState.FAILED) {
                        connector.start();
                    }
                }
                catch (Exception e) {
                    log.error(sm.getString("standardService.connector.startFailed", connector), e);
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        Object object = this.connectors;
        synchronized (this.connectors) {
            Connector connector;
            Connector[] connectorArray = this.connectors;
            int n = this.connectors.length;
            int n2 = 0;
            while (n2 < n) {
                connector = connectorArray[n2];
                try {
                    connector.pause();
                }
                catch (Exception e) {
                    log.error(sm.getString("standardService.connector.pauseFailed", connector), e);
                }
                ++n2;
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            if (log.isInfoEnabled()) {
                log.info(sm.getString("standardService.stop.name", this.name));
            }
            this.setState(LifecycleState.STOPPING);
            if (this.container != null) {
                object = this.container;
                synchronized (object) {
                    this.container.stop();
                }
            }
            object = this.connectors;
            synchronized (this.connectors) {
                connectorArray = this.connectors;
                n = this.connectors.length;
                n2 = 0;
                while (n2 < n) {
                    connector = connectorArray[n2];
                    if (LifecycleState.STARTED.equals((Object)connector.getState())) {
                        try {
                            connector.stop();
                        }
                        catch (Exception e) {
                            log.error(sm.getString("standardService.connector.stopFailed", connector), e);
                        }
                    }
                    ++n2;
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                object = this.executors;
                synchronized (object) {
                    for (Executor executor : this.executors) {
                        executor.stop();
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.container.init();
        }
        Executor[] executorArray = this.findExecutors();
        int n = executorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executor executor = executorArray[n2];
            if (executor instanceof LifecycleMBeanBase) {
                ((LifecycleMBeanBase)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
            ++n2;
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            Connector[] connectorArray2 = this.connectors;
            int n3 = this.connectors.length;
            n = 0;
            while (n < n3) {
                block9: {
                    Connector connector = connectorArray2[n];
                    try {
                        connector.init();
                    }
                    catch (Exception e) {
                        String message = sm.getString("standardService.connector.initFailed", connector);
                        log.error(message, e);
                        if (!Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) break block9;
                        throw new LifecycleException(message);
                    }
                }
                ++n;
            }
            // ** MonitorExit[var1_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            Connector[] connectorArray2 = this.connectors;
            int n = this.connectors.length;
            int n2 = 0;
            while (n2 < n) {
                Connector connector = connectorArray2[n2];
                try {
                    connector.destroy();
                }
                catch (Exception e) {
                    log.error(sm.getString("standardService.connector.destroyfailed", connector), e);
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Executor[] executorArray = this.findExecutors();
            n2 = executorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Executor executor = executorArray[n3];
                executor.destroy();
                ++n3;
            }
            if (this.container != null) {
                this.container.destroy();
            }
            super.destroyInternal();
            return;
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

