/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BioSender
extends AbstractSender {
    private static final Log log = LogFactory.getLog(BioSender.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private static final String info = "DataSender/3.0";
    private Socket socket = null;
    private OutputStream soOut = null;
    private InputStream soIn = null;
    protected XByteBuffer ackbuf = new XByteBuffer(Constants.ACK_COMMAND.length, true);

    public String getInfo() {
        return info;
    }

    @Override
    public void connect() throws IOException {
        this.openSocket();
    }

    @Override
    public void disconnect() {
        boolean connect = this.isConnected();
        this.closeSocket();
        if (connect && log.isDebugEnabled()) {
            log.debug(sm.getString("IDataSender.disconnect", this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(0L)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void sendMessage(byte[] data, boolean waitForAck) throws IOException {
        block10: {
            exception = null;
            this.setAttempt(0);
            try {
                try {
                    this.pushMessage(data, false, waitForAck);
                    break block10;
                }
                catch (IOException x) {
                    SenderState.getSenderState(this.getDestination()).setSuspect();
                    exception = x;
                    if (BioSender.log.isTraceEnabled()) {
                        BioSender.log.trace(BioSender.sm.getString("IDataSender.send.again", new Object[]{this.getAddress().getHostAddress(), new Integer(this.getPort())}), x);
                    }
                    ** while (this.getAttempt() < this.getMaxRetryAttempts())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.setAttempt(this.getAttempt() + 1);
                        this.pushMessage(data, true, waitForAck);
                        exception = null;
                    }
                    catch (IOException xx) {
                        exception = xx;
                        this.closeSocket();
                    }
                    continue;
lbl22:
                    // 1 sources

                }
            }
            finally {
                this.setRequestCount(this.getRequestCount() + 1);
                this.keepalive();
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("DataSender[(");
        buf.append(super.toString()).append(")");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void openSocket() throws IOException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.socket = new Socket();
            InetSocketAddress sockaddr = new InetSocketAddress(this.getAddress(), this.getPort());
            this.socket.connect(sockaddr, (int)this.getTimeout());
            this.socket.setSendBufferSize(this.getTxBufSize());
            this.socket.setReceiveBufferSize(this.getRxBufSize());
            this.socket.setSoTimeout((int)this.getTimeout());
            this.socket.setTcpNoDelay(this.getTcpNoDelay());
            this.socket.setKeepAlive(this.getSoKeepAlive());
            this.socket.setReuseAddress(this.getSoReuseAddress());
            this.socket.setOOBInline(this.getOoBInline());
            this.socket.setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
            this.socket.setTrafficClass(this.getSoTrafficClass());
            this.setConnected(true);
            this.soOut = this.socket.getOutputStream();
            this.soIn = this.socket.getInputStream();
            this.setRequestCount(0);
            this.setConnectTime(System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("IDataSender.openSocket", this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(0L)));
            }
        }
        catch (IOException ex1) {
            SenderState.getSenderState(this.getDestination()).setSuspect();
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("IDataSender.openSocket.failure", this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(0L)), ex1);
            }
            throw ex1;
        }
    }

    protected void closeSocket() {
        if (this.isConnected()) {
            block8: {
                if (this.socket != null) {
                    try {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            this.socket = null;
                            this.soOut = null;
                            this.soIn = null;
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        this.socket = null;
                        this.soOut = null;
                        this.soIn = null;
                        throw throwable;
                    }
                    this.socket = null;
                    this.soOut = null;
                    this.soIn = null;
                }
            }
            this.setRequestCount(0);
            this.setConnected(false);
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("IDataSender.closeSocket", this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(0L)));
            }
        }
    }

    protected void pushMessage(byte[] data, boolean reconnect, boolean waitForAck) throws IOException {
        this.keepalive();
        if (reconnect) {
            this.closeSocket();
        }
        if (!this.isConnected()) {
            this.openSocket();
        }
        this.soOut.write(data);
        this.soOut.flush();
        if (waitForAck) {
            this.waitForAck();
        }
        SenderState.getSenderState(this.getDestination()).setReady();
    }

    protected void waitForAck() throws IOException {
        try {
            try {
                boolean ackReceived = false;
                boolean failAckReceived = false;
                this.ackbuf.clear();
                int bytesRead = 0;
                int i = this.soIn.read();
                while (i != -1 && bytesRead < Constants.ACK_COMMAND.length) {
                    ++bytesRead;
                    byte d = (byte)i;
                    this.ackbuf.append(d);
                    if (this.ackbuf.doesPackageExist()) {
                        byte[] ackcmd = this.ackbuf.extractDataPackage(true).getBytes();
                        ackReceived = Arrays.equals(ackcmd, Constants.ACK_DATA);
                        failAckReceived = Arrays.equals(ackcmd, Constants.FAIL_ACK_DATA);
                        ackReceived = ackReceived || failAckReceived;
                        break;
                    }
                    i = this.soIn.read();
                }
                if (!ackReceived) {
                    if (i == -1) {
                        throw new IOException(sm.getString("IDataSender.ack.eof", this.getAddress(), new Integer(this.socket.getLocalPort())));
                    }
                    throw new IOException(sm.getString("IDataSender.ack.wrong", this.getAddress(), new Integer(this.socket.getLocalPort())));
                }
                if (failAckReceived && this.getThrowOnFailedAck()) {
                    throw new RemoteProcessException("Received a failed ack:org.apache.catalina.tribes.transport.Constants.FAIL_ACK_DATA");
                }
            }
            catch (IOException x) {
                String errmsg = sm.getString("IDataSender.ack.missing", this.getAddress(), new Integer(this.socket.getLocalPort()), new Long(this.getTimeout()));
                if (SenderState.getSenderState(this.getDestination()).isReady()) {
                    SenderState.getSenderState(this.getDestination()).setSuspect();
                    if (log.isWarnEnabled()) {
                        log.warn(errmsg, x);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(errmsg, x);
                }
                throw x;
            }
        }
        finally {
            this.ackbuf.clear();
        }
    }
}

