/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.jsp.tagext.FunctionInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.Node;

public class ELFunctionMapper {
    private int currFunc = 0;
    StringBuilder ds;
    StringBuilder ss;

    public static void map(Node.Nodes page) throws JasperException {
        ELFunctionMapper map = new ELFunctionMapper();
        map.ds = new StringBuilder();
        map.ss = new StringBuilder();
        page.visit(map.new ELFunctionVisitor());
        String ds = map.ds.toString();
        if (ds.length() > 0) {
            Node.Root root = page.getRoot();
            new Node.Declaration(map.ss.toString(), null, root);
            new Node.Declaration("static {\n" + ds + "}\n", null, root);
        }
    }

    class ELFunctionVisitor
    extends Node.Visitor {
        private HashMap<String, String> gMap = new HashMap();

        ELFunctionVisitor() {
        }

        @Override
        public void visit(Node.ParamAction n) throws JasperException {
            this.doMap(n.getValue());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.IncludeAction n) throws JasperException {
            this.doMap(n.getPage());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ForwardAction n) throws JasperException {
            this.doMap(n.getPage());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.SetProperty n) throws JasperException {
            this.doMap(n.getValue());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UseBean n) throws JasperException {
            this.doMap(n.getBeanName());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.PlugIn n) throws JasperException {
            this.doMap(n.getHeight());
            this.doMap(n.getWidth());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.JspElement n) throws JasperException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                this.doMap(attrs[i]);
                ++i;
            }
            this.doMap(n.getNameAttribute());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UninterpretedTag n) throws JasperException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                this.doMap(attrs[i]);
                ++i;
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (attrs != null && i < attrs.length) {
                this.doMap(attrs[i]);
                ++i;
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ELExpression n) throws JasperException {
            this.doMap(n.getEL());
        }

        private void doMap(Node.JspAttribute attr) throws JasperException {
            if (attr != null) {
                this.doMap(attr.getEL());
            }
        }

        private void doMap(ELNode.Nodes el) throws JasperException {
            if (el == null) {
                return;
            }
            class Fvisitor
            extends ELNode.Visitor {
                ArrayList<ELNode.Function> funcs = new ArrayList();
                HashMap<String, String> keyMap = new HashMap();

                Fvisitor() {
                }

                @Override
                public void visit(ELNode.Function n) throws JasperException {
                    String key = String.valueOf(n.getPrefix()) + ":" + n.getName();
                    if (!this.keyMap.containsKey(key)) {
                        this.keyMap.put(key, "");
                        this.funcs.add(n);
                    }
                }
            }
            Fvisitor fv = new Fvisitor();
            el.visit(fv);
            ArrayList<ELNode.Function> functions = fv.funcs;
            if (functions.size() == 0) {
                return;
            }
            String decName = this.matchMap(functions);
            if (decName != null) {
                el.setMapName(decName);
                return;
            }
            decName = this.getMapName();
            ELFunctionMapper.this.ss.append("private static org.apache.jasper.runtime.ProtectedFunctionMapper " + decName + ";\n");
            ELFunctionMapper.this.ds.append("  " + decName + "= ");
            ELFunctionMapper.this.ds.append("org.apache.jasper.runtime.ProtectedFunctionMapper");
            String funcMethod = null;
            if (functions.size() == 1) {
                funcMethod = ".getMapForFunction";
            } else {
                ELFunctionMapper.this.ds.append(".getInstance();\n");
                funcMethod = "  " + decName + ".mapFunction";
            }
            int i = 0;
            while (i < functions.size()) {
                ELNode.Function f = functions.get(i);
                FunctionInfo funcInfo = f.getFunctionInfo();
                String key = String.valueOf(f.getPrefix()) + ":" + f.getName();
                ELFunctionMapper.this.ds.append(String.valueOf(funcMethod) + "(\"" + key + "\", " + this.getCanonicalName(funcInfo.getFunctionClass()) + ".class, " + '\"' + f.getMethodName() + "\", " + "new Class[] {");
                String[] params = f.getParameters();
                int k = 0;
                while (k < params.length) {
                    int iArray;
                    if (k != 0) {
                        ELFunctionMapper.this.ds.append(", ");
                    }
                    if ((iArray = params[k].indexOf(91)) < 0) {
                        ELFunctionMapper.this.ds.append(String.valueOf(params[k]) + ".class");
                    } else {
                        String baseType = params[k].substring(0, iArray);
                        ELFunctionMapper.this.ds.append("java.lang.reflect.Array.newInstance(");
                        ELFunctionMapper.this.ds.append(baseType);
                        ELFunctionMapper.this.ds.append(".class,");
                        int aCount = 0;
                        int jj = iArray;
                        while (jj < params[k].length()) {
                            if (params[k].charAt(jj) == '[') {
                                ++aCount;
                            }
                            ++jj;
                        }
                        if (aCount == 1) {
                            ELFunctionMapper.this.ds.append("0).getClass()");
                        } else {
                            ELFunctionMapper.this.ds.append("new int[" + aCount + "]).getClass()");
                        }
                    }
                    ++k;
                }
                ELFunctionMapper.this.ds.append("});\n");
                this.gMap.put(String.valueOf(f.getPrefix()) + ':' + f.getName() + ':' + f.getUri(), decName);
                ++i;
            }
            el.setMapName(decName);
        }

        private String matchMap(ArrayList<ELNode.Function> functions) {
            String mapName = null;
            int i = 0;
            while (i < functions.size()) {
                ELNode.Function f = functions.get(i);
                String temName = this.gMap.get(String.valueOf(f.getPrefix()) + ':' + f.getName() + ':' + f.getUri());
                if (temName == null) {
                    return null;
                }
                if (mapName == null) {
                    mapName = temName;
                } else if (!temName.equals(mapName)) {
                    return null;
                }
                ++i;
            }
            return mapName;
        }

        private String getMapName() {
            StringBuilder stringBuilder = new StringBuilder("_jspx_fnmap_");
            ELFunctionMapper eLFunctionMapper = ELFunctionMapper.this;
            int n = eLFunctionMapper.currFunc;
            eLFunctionMapper.currFunc = n + 1;
            return stringBuilder.append(n).toString();
        }

        private String getCanonicalName(String className) throws JasperException {
            Class<?> clazz;
            ClassLoader tccl;
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedGetTccl pa = new PrivilegedGetTccl();
                tccl = AccessController.doPrivileged(pa);
            } else {
                tccl = Thread.currentThread().getContextClassLoader();
            }
            try {
                clazz = Class.forName(className, false, tccl);
            }
            catch (ClassNotFoundException e) {
                throw new JasperException(e);
            }
            return clazz.getCanonicalName();
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

