/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.jasper.Constants;

public final class ELResolverImpl
extends ELResolver {
    private static final ELResolver DefaultResolver;
    private final VariableResolver variableResolver;
    private final ELResolver elResolver;

    static {
        if (Constants.IS_SECURITY_ENABLED) {
            DefaultResolver = null;
        } else {
            DefaultResolver = new CompositeELResolver();
            ((CompositeELResolver)DefaultResolver).add(new MapELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ResourceBundleELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ListELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ArrayELResolver());
            ((CompositeELResolver)DefaultResolver).add(new BeanELResolver());
        }
    }

    public ELResolverImpl(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
        this.elResolver = ELResolverImpl.getDefaultResolver();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    return this.variableResolver.resolveVariable(property.toString());
                }
                catch (ELException e) {
                    throw new javax.el.ELException(e.getMessage(), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return this.elResolver.getValue(context, base, property);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    Object obj = this.variableResolver.resolveVariable(property.toString());
                    return obj != null ? obj.getClass() : null;
                }
                catch (ELException e) {
                    throw new javax.el.ELException(e.getMessage(), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return this.elResolver.getType(context, base, property);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException("Legacy VariableResolver wrapped, not writable");
        }
        if (!context.isPropertyResolved()) {
            this.elResolver.setValue(context, base, property, value);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            return true;
        }
        return this.elResolver.isReadOnly(context, base, property);
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return this.elResolver.getFeatureDescriptors(context, base);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return this.elResolver.getCommonPropertyType(context, base);
    }

    public static ELResolver getDefaultResolver() {
        if (Constants.IS_SECURITY_ENABLED) {
            CompositeELResolver defaultResolver = new CompositeELResolver();
            defaultResolver.add(new MapELResolver());
            defaultResolver.add(new ResourceBundleELResolver());
            defaultResolver.add(new ListELResolver());
            defaultResolver.add(new ArrayELResolver());
            defaultResolver.add(new BeanELResolver());
            return defaultResolver;
        }
        return DefaultResolver;
    }
}

