/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.zip.CRC32;
import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.swt.graphics.Rectangle;

public class QxBoxDimensions
implements QxType {
    public static final QxBoxDimensions ZERO = new QxBoxDimensions(0, 0, 0, 0);
    public final int top;
    public final int right;
    public final int bottom;
    public final int left;

    private QxBoxDimensions(int top, int right, int bottom, int left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public static QxBoxDimensions create(int top, int right, int bottom, int left) {
        QxBoxDimensions result = top == 0 && right == 0 && bottom == 0 && left == 0 ? ZERO : new QxBoxDimensions(top, right, bottom, left);
        return result;
    }

    public static QxBoxDimensions valueOf(String input) {
        int left;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        String[] parts = input.split("\\s+");
        if (parts.length == 0 || parts.length > 4) {
            String msg = "Illegal number of arguments for box dimensions";
            throw new IllegalArgumentException(msg);
        }
        int bottom = left = QxBoxDimensions.parsePxValue(parts[0]);
        int right = left;
        int top = left;
        if (parts.length >= 2) {
            right = left = QxBoxDimensions.parsePxValue(parts[1]);
        }
        if (parts.length >= 3) {
            bottom = QxBoxDimensions.parsePxValue(parts[2]);
        }
        if (parts.length == 4) {
            left = QxBoxDimensions.parsePxValue(parts[3]);
        }
        return QxBoxDimensions.create(top, right, bottom, left);
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public String toJsArray() {
        return "[ " + this.top + ", " + this.right + ", " + this.bottom + ", " + this.left + " ]";
    }

    public String toDefaultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(this.top) + "px");
        if (this.right != this.top || this.bottom != this.top || this.left != this.top) {
            buffer.append(" " + this.right + "px");
        }
        if (this.bottom != this.top || this.left != this.right) {
            buffer.append(" " + this.bottom + "px");
        }
        if (this.left != this.right) {
            buffer.append(" " + this.left + "px");
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxBoxDimensions) {
            QxBoxDimensions other = (QxBoxDimensions)object;
            result = other.top == this.top && other.right == this.right && other.bottom == this.bottom && other.left == this.left;
        }
        return result;
    }

    public int hashCode() {
        CRC32 result = new CRC32();
        result.update(this.top);
        result.update(this.right);
        result.update(this.bottom);
        result.update(this.left);
        return (int)result.getValue();
    }

    public String toString() {
        return "QxBoxDimensions{ " + this.top + ", " + this.right + ", " + this.bottom + ", " + this.left + " }";
    }

    private static int parsePxValue(String part) {
        Integer result = QxDimension.parseLength(part);
        if (result == null) {
            throw new IllegalArgumentException("Illegal parameter: " + part);
        }
        return result;
    }

    public static Rectangle createRectangle(QxBoxDimensions boxdim) {
        return new Rectangle(boxdim.left, boxdim.top, boxdim.left + boxdim.right, boxdim.top + boxdim.bottom);
    }
}

