/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.completion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.commands.CommandsTracker;
import org.eclipse.equinox.console.completion.CommandLineParser;
import org.eclipse.equinox.console.completion.StringsCompleter;
import org.eclipse.equinox.console.completion.common.Completer;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNamesCompleter
implements Completer {
    private CommandSession session;
    private ServiceTracker<CommandsTracker, CommandsTracker> commandsTrackerTracker;
    private static final String COMMANDS = ".commands";

    public CommandNamesCompleter(BundleContext context, CommandSession session) {
        this.session = session;
        this.commandsTrackerTracker = new ServiceTracker(context, CommandsTracker.class.getName(), null);
        this.commandsTrackerTracker.open();
    }

    @Override
    public Map<String, Integer> getCandidates(String buffer, int cursor) {
        String currentToken;
        CommandsTracker commandsTracker = (CommandsTracker)this.commandsTrackerTracker.getService();
        Set<String> commandNames = null;
        if (commandsTracker != null) {
            commandNames = commandsTracker.getCommands();
        }
        if (commandNames == null || commandNames.isEmpty()) {
            commandNames = (Set<String>)this.session.get(COMMANDS);
        }
        if ((currentToken = CommandLineParser.getCurrentToken(buffer, cursor).toLowerCase()) == null || currentToken.equals("")) {
            return new HashMap<String, Integer>();
        }
        if (!currentToken.contains(":")) {
            commandNames = this.clearScopes(commandNames);
        }
        StringsCompleter completer = new StringsCompleter(commandNames, true);
        return completer.getCandidates(buffer, cursor);
    }

    private Set<String> clearScopes(Set<String> commandNames) {
        HashSet<String> clearedCommandNames = new HashSet<String>();
        for (String commandName : commandNames) {
            clearedCommandNames.add(commandName.substring(commandName.indexOf(":") + 1));
        }
        return clearedCommandNames;
    }
}

