/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import org.eclipse.sapphire.java.ClassBasedJavaType;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class StandardJavaTypeReferenceService
extends JavaTypeReferenceService {
    private final ClassLocator classLocator;

    public StandardJavaTypeReferenceService(ClassLocator classLocator) {
        this.classLocator = classLocator;
    }

    public StandardJavaTypeReferenceService(final ClassLoader classLoader) {
        this(new ClassLocator(){

            public Class<?> find(String name) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }

    public JavaType resolve(String name) {
        Class cl = this.classLocator.find(name);
        if (cl != null) {
            return new ClassBasedJavaType(cl);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            Reference referenceAnnotation;
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && property.getTypeClass() == JavaTypeName.class && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            IModelElement element = (IModelElement)context.find(IModelElement.class);
            ClassLocator classLocator = (ClassLocator)element.adapt(ClassLocator.class);
            if (classLocator != null) {
                return new StandardJavaTypeReferenceService(classLocator);
            }
            ClassLoader classLoader = element.getModelElementType().getModelElementClass().getClassLoader();
            return new StandardJavaTypeReferenceService(classLoader);
        }
    }
}

