/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.java.ClassBasedJavaType;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class StandardJavaTypeReferenceService
extends JavaTypeReferenceService {
    private final Context context;

    public StandardJavaTypeReferenceService(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    public StandardJavaTypeReferenceService(ClassLoader loader) {
        this(Context.adapt((ClassLoader)loader));
    }

    public JavaType resolve(String name) {
        Class cl = this.context.findClass(name);
        if (cl != null) {
            return new ClassBasedJavaType(cl);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            Reference referenceAnnotation;
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && property.getTypeClass() == JavaTypeName.class && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            IModelElement element = (IModelElement)context.find(IModelElement.class);
            Context ctxt = (Context)element.adapt(Context.class);
            if (ctxt == null) {
                ctxt = Context.adapt((ClassLoader)element.type().getModelElementClass().getClassLoader());
            }
            return new StandardJavaTypeReferenceService(ctxt);
        }
    }
}

