/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.ui.internal;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaPackageName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class JavaPackageBrowseActionHandler
extends BrowseActionHandler {
    @Text(value="Select {0}")
    private static LocalizableText dialogTitle;
    @Text(value="Choose a package:")
    private static LocalizableText dialogMessage;
    public static final String ID = "Sapphire.Browse.Java.Package";

    static {
        LocalizableText.init(JavaPackageBrowseActionHandler.class);
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
    }

    public String browse(Presentation context) {
        Value property = this.property();
        IJavaProject project = (IJavaProject)property.element().adapt(IJavaProject.class);
        try {
            SelectionDialog dlg = JavaUI.createPackageDialog((Shell)((FormComponentPresentation)context).shell(), (IJavaProject)project, (int)0, null);
            dlg.setTitle(dialogTitle.format(new Object[]{property.definition().getLabel(true, CapitalizationType.TITLE_STYLE, false)}));
            dlg.setMessage(dialogMessage.text());
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IPackageFragment) {
                    return ((IPackageFragment)results[0]).getElementName();
                }
            }
        }
        catch (JavaModelException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return null;
    }

    public static final class Condition
    extends PropertyEditorCondition {
        protected boolean evaluate(PropertyEditorPart part) {
            Property property = part.property();
            return property instanceof Value && property.definition().isOfType(JavaPackageName.class) && property.element().adapt(IJavaProject.class) != null;
        }
    }
}

