/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TypeCastUtility;

public final class NumberUtility {
    private static final Random RANDOMIZER = new Random();

    private NumberUtility() {
    }

    public static Double toDouble(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Float) {
            return new Double(n.toString());
        }
        return new Double(n.doubleValue());
    }

    public static Integer toInteger(Number n) {
        if (n == null) {
            return null;
        }
        return n.intValue();
    }

    public static Long toLong(Number n) {
        if (n == null) {
            return null;
        }
        return n.longValue();
    }

    public static BigDecimal toBigDecimal(Double d) {
        if (d == null) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public static BigInteger toBigInteger(Long l) {
        if (l == null) {
            return null;
        }
        return BigInteger.valueOf(l);
    }

    public static double avg(double ... a) {
        if (a == null) {
            return 0.0;
        }
        long count = a.length;
        double sum = NumberUtility.sum(a);
        if (count > 0L) {
            return sum / (double)count;
        }
        return 0.0;
    }

    public static double median(double ... a) {
        if (a == null) {
            return 0.0;
        }
        int count = a.length;
        double[] b = new double[a.length];
        System.arraycopy(a, 0, b, 0, count);
        Arrays.sort(b);
        if (count > 0) {
            return b[count / 2];
        }
        return 0.0;
    }

    public static boolean hasBit(int value, int index) {
        return NumberUtility.getBit(value, index);
    }

    public static boolean getBit(int value, int index) {
        return (value & 1 << index) != 0;
    }

    public static double sum(double ... a) {
        if (a == null) {
            return 0.0;
        }
        if (a.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }

    public static long sum(long ... a) {
        if (a == null) {
            return 0L;
        }
        if (a.length == 0) {
            return 0L;
        }
        long sum = 0L;
        long[] lArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }

    public static double min(double ... a) {
        if (a == null) {
            return 0.0;
        }
        if (a.length == 0) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            min = Math.min(min, d);
            ++n2;
        }
        return min;
    }

    public static double max(double ... a) {
        if (a == null) {
            return 0.0;
        }
        if (a.length == 0) {
            return 0.0;
        }
        double max = Double.MIN_VALUE;
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            max = Math.max(max, d);
            ++n2;
        }
        return max;
    }

    public static long randomLong() {
        return RANDOMIZER.nextLong();
    }

    public static long randomInt() {
        return RANDOMIZER.nextInt();
    }

    public static long randomInt(int size) {
        return RANDOMIZER.nextInt(size);
    }

    public static double randomDouble() {
        return RANDOMIZER.nextDouble();
    }

    public static Number roundBigDecimal(Number value, double precision) {
        if (value != null) {
            BigDecimal val = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
            BigDecimal prec = BigDecimal.valueOf(precision);
            return val.divide(prec, 6).setScale(0, 6).multiply(prec);
        }
        return null;
    }

    public static double round(double value, double precision) {
        return (double)Math.round(value / precision) * precision;
    }

    public static int setBit(int value, int index) {
        return value | 1 << index;
    }

    public static int clearBit(int value, int index) {
        return value & (value ^ 1 << index);
    }

    public static Number sign(Number n) {
        if (n == null) {
            return new Integer(0);
        }
        double d = n.doubleValue();
        if (d < 0.0) {
            return new Integer(-1);
        }
        if (d > 0.0) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    public static int parseInt(String s) {
        if (s == null) {
            return 0;
        }
        return TypeCastUtility.castValue(s, Integer.class);
    }

    public static long parseLong(String s) {
        if (s == null) {
            return 0L;
        }
        return TypeCastUtility.castValue(s, Long.class);
    }

    public static double parseDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        return TypeCastUtility.castValue(s, Double.class);
    }

    public static String format(Number n) {
        if (n == null) {
            return "";
        }
        Locale loc = LocaleThreadLocal.get();
        if (loc == null) {
            loc = Locale.getDefault();
        }
        return NumberFormat.getInstance(loc).format(n);
    }

    public static <T> T nvl(T value, T valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static int nvl(Integer value, Number valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull.intValue();
    }

    public static long nvl(Long value, Number valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull.longValue();
    }

    public static double trunc(Number n) {
        if (n == null) {
            return 0.0;
        }
        return Math.floor(n.doubleValue());
    }

    public static int longToInt(Long l) {
        if (l != null) {
            if (new Long(Integer.MAX_VALUE).compareTo(l) == -1) {
                return Integer.MAX_VALUE;
            }
            if (new Long(Integer.MIN_VALUE).compareTo(l) == 1) {
                return Integer.MIN_VALUE;
            }
            return l.intValue();
        }
        return 0;
    }

    public static BigDecimal getBigDecimalValue(Object o) {
        if (o != null && o.toString().length() > 0) {
            return new BigDecimal(o.toString());
        }
        return null;
    }

    public static Double divide(Double numerator, Double denominator) {
        if (numerator == null || denominator == null || denominator.equals(0.0)) {
            return null;
        }
        if (numerator.equals(0.0)) {
            return 0.0;
        }
        return numerator / denominator;
    }
}

