/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.java;

import java.io.File;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.EclipseLogUtility;
import org.eclipse.scout.commons.logger.IScoutLogManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.JavaLogUtility;
import org.eclipse.scout.commons.logger.internal.java.JavaLogFormatter;
import org.eclipse.scout.commons.logger.internal.java.JavaLogWrapper;
import org.eclipse.scout.commons.logger.internal.java.LogRecorderHandler;

public class JavaScoutLogManager
implements IScoutLogManager {
    private Object m_recordingLock = new Object();
    private LogRecorderHandler m_logRecorderHandler;
    private ILogListener m_eclipseLogListener = new P_EclipseToJavaDelegateListener();
    private boolean m_globalLogLevelSet;

    @Override
    public void initialize() {
        Logger root;
        if (Platform.isRunning()) {
            Platform.addLogListener((ILogListener)this.m_eclipseLogListener);
        }
        if ((root = Logger.getLogger("")).getLevel() == Level.INFO && System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null) {
            root.setLevel(Level.WARNING);
        }
        Handler[] handlerArray = root.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (h.getFormatter() instanceof SimpleFormatter) {
                h.setFormatter(new JavaLogFormatter());
            }
            ++n2;
        }
    }

    @Override
    public IScoutLogger getLogger(String name) {
        return new JavaLogWrapper(name);
    }

    @Override
    public IScoutLogger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    @Override
    public void setGlobalLogLevel(Integer globalLogLevel) {
        if (globalLogLevel == null) {
            this.m_globalLogLevelSet = false;
            try {
                LogManager.getLogManager().getLogger("").setLevel(null);
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e) {
                this.getLogger(JavaScoutLogManager.class).error("could not restore logging configuration", e);
            }
        } else {
            this.m_globalLogLevelSet = true;
            Level javaLogLevel = JavaLogUtility.scoutToJavaLevel(globalLogLevel);
            Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                Logger logger = LogManager.getLogManager().getLogger(loggerNames.nextElement());
                if (logger == null) continue;
                if (logger.getLevel() != null && logger.getLevel() != javaLogLevel) {
                    logger.setLevel(null);
                }
                Handler[] handlerArray = logger.getHandlers();
                int n = handlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Handler handler = handlerArray[n2];
                    handler.setLevel(javaLogLevel);
                    ++n2;
                }
            }
            LogManager.getLogManager().getLogger("").setLevel(javaLogLevel);
        }
    }

    @Override
    public Integer getGlobalLogLevel() {
        if (this.m_globalLogLevelSet) {
            Level level = LogManager.getLogManager().getLogger("").getLevel();
            return JavaLogUtility.javaToScoutLevel(level);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startRecording() throws ProcessingException {
        Object object = this.m_recordingLock;
        synchronized (object) {
            block4: {
                if (this.m_logRecorderHandler != null) break block4;
                this.m_logRecorderHandler = this.createLogRecordingHandler();
                Logger root = Logger.getLogger("");
                root.addHandler(this.m_logRecorderHandler);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File stopRecording() {
        Object object = this.m_recordingLock;
        synchronized (object) {
            block4: {
                if (this.m_logRecorderHandler != null) break block4;
                return null;
            }
            File logFile = this.m_logRecorderHandler.getLogFile();
            this.m_logRecorderHandler = null;
            Logger root = Logger.getLogger("");
            root.removeHandler(this.m_logRecorderHandler);
            return logFile;
        }
    }

    protected LogRecorderHandler createLogRecordingHandler() throws ProcessingException {
        try {
            File tempLogDir = IOUtility.createTempDirectory("log");
            LogRecorderHandler handler = new LogRecorderHandler(tempLogDir.getAbsolutePath(), 0x100000, 1024, false);
            handler.setLevel(Level.FINEST);
            handler.setFormatter(new JavaLogFormatter());
            handler.setEncoding("UTF-8");
            return handler;
        }
        catch (Exception e) {
            throw new ProcessingException("could not create handler to record log messages", e);
        }
    }

    private final class P_EclipseToJavaDelegateListener
    implements ILogListener {
        private P_EclipseToJavaDelegateListener() {
        }

        public void logging(IStatus status, String plugin) {
            int scoutLogLevel = EclipseLogUtility.eclipseToScoutLevel(status.getSeverity());
            Level javaLogLevel = JavaLogUtility.scoutToJavaLevel(scoutLogLevel);
            String codeText = status.getCode() != 0 ? "[code " + status.getCode() + "] " : "";
            LogRecord record = new LogRecord(javaLogLevel, String.valueOf(codeText) + status.getMessage());
            record.setLoggerName(plugin);
            if (status.getPlugin() != null && status.getPlugin().length() > 0) {
                record.setSourceClassName(status.getPlugin());
            } else {
                record.setSourceClassName(plugin);
            }
            record.setSourceMethodName(null);
            record.setThrown(status.getException());
            Logger.getLogger(record.getLoggerName()).log(record);
        }
    }
}

