/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.net;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.ProxySelector;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scout.net.EclipseAuthenticator;
import org.eclipse.scout.net.EclipseProxySelector;
import org.osgi.framework.BundleContext;

public final class NetActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.net";
    public static boolean DEBUG;
    public static boolean PROXY_AUTODETECTION;
    private static NetActivator plugin;
    private CookieHandler m_oldCookieHandler;
    private CookieHandler m_newCookieHandler;
    private ProxySelector m_oldProxySelector;
    private ProxySelector m_newProxySelector;

    public static NetActivator getDefault() {
        return plugin;
    }

    public static void install() {
        NetActivator.getDefault();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        String debugText = context.getProperty("org.eclipse.scout.net.debug");
        DEBUG = debugText != null && debugText.equalsIgnoreCase("true");
        String proxyDetectionText = context.getProperty("org.eclipse.scout.net.proxy.autodetect");
        PROXY_AUTODETECTION = proxyDetectionText == null || proxyDetectionText.equalsIgnoreCase("true");
        this.m_oldProxySelector = ProxySelector.getDefault();
        this.m_oldCookieHandler = CookieHandler.getDefault();
        if (PROXY_AUTODETECTION) {
            this.m_newProxySelector = new EclipseProxySelector();
            ProxySelector.setDefault(this.m_newProxySelector);
        }
        this.m_newCookieHandler = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        CookieManager.setDefault(this.m_newCookieHandler);
        Authenticator.setDefault(new EclipseAuthenticator());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        Authenticator.setDefault(null);
        if (ProxySelector.getDefault() == this.m_newProxySelector) {
            ProxySelector.setDefault(this.m_oldProxySelector);
        }
        if (CookieHandler.getDefault() == this.m_newCookieHandler) {
            CookieHandler.setDefault(this.m_oldCookieHandler);
        }
        this.m_oldProxySelector = null;
        this.m_newProxySelector = null;
        this.m_oldCookieHandler = null;
        this.m_newCookieHandler = null;
        plugin = null;
    }
}

