/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.net.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.net.NetActivator;
import org.eclipse.scout.net.internal.EclipseAuthenticatorLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class InternalEclipseAuthenticator
extends Authenticator {
    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        BundleContext context;
        ServiceReference ref;
        PasswordAuthentication result = null;
        Authenticator auth = new EclipseAuthenticatorLocator().locate();
        if (auth == null && (ref = (context = NetActivator.getDefault().getBundle().getBundleContext()).getServiceReference(Authenticator.class.getName())) != null) {
            auth = (Authenticator)context.getService(ref);
            context.ungetService(ref);
        }
        if (auth != null) {
            try {
                result = this.reflectPasswordAuthentication(auth);
            }
            catch (Throwable ex) {
                NetActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scout.net", this.getRequestingURL() + " " + (Object)((Object)this.getRequestorType()), ex));
                throw new SecurityException(ex);
            }
        }
        if (result != null) {
            if (NetActivator.DEBUG) {
                NetActivator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.scout.net", "net.auth SUCCESS " + this.getRequestingURL() + " " + (Object)((Object)this.getRequestorType()) + " " + result.getUserName()));
            }
            return result;
        }
        if (NetActivator.DEBUG) {
            NetActivator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.scout.net", "net.auth NONE " + this.getRequestingURL() + " " + (Object)((Object)this.getRequestorType())));
        }
        return null;
    }

    private PasswordAuthentication reflectPasswordAuthentication(Authenticator delegate) throws Throwable {
        this.reflectCopyField(this, delegate, "requestingHost");
        this.reflectCopyField(this, delegate, "requestingSite");
        this.reflectCopyField(this, delegate, "requestingPort");
        this.reflectCopyField(this, delegate, "requestingProtocol");
        this.reflectCopyField(this, delegate, "requestingPrompt");
        this.reflectCopyField(this, delegate, "requestingScheme");
        this.reflectCopyField(this, delegate, "requestingURL");
        this.reflectCopyField(this, delegate, "requestingAuthType");
        Method m = delegate.getClass().getDeclaredMethod("getPasswordAuthentication", new Class[0]);
        m.setAccessible(true);
        return (PasswordAuthentication)m.invoke((Object)delegate, new Object[0]);
    }

    private void reflectCopyField(Authenticator from, Authenticator to, String fieldName) throws Throwable {
        Field f = Authenticator.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        Object value = f.get(from);
        f.set(to, value);
    }
}

