/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.booleanfield;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class AbstractBooleanField
extends AbstractValueField<Boolean>
implements IBooleanField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBooleanField.class);
    private IBooleanFieldUIFacade m_uiFacade;

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.propertySupport.setProperty("value", (Object)false);
        this.propertySupport.setProperty("displayText", (Object)this.execFormatValue((Boolean)this.getValue()));
    }

    @Override
    public void setChecked(boolean b) {
        this.setValue(b);
    }

    @Override
    public boolean isChecked() {
        return this.getValue() != null && (Boolean)this.getValue() != false;
    }

    @Override
    protected String formatValueInternal(Boolean validValue) {
        if (validValue == null) {
            return "";
        }
        return validValue != false ? ScoutTexts.get((String)"Yes", (String[])new String[0]) : ScoutTexts.get((String)"No", (String[])new String[0]);
    }

    @Override
    protected Boolean validateValueInternal(Boolean rawValue) throws ProcessingException {
        Boolean validValue = null;
        validValue = rawValue = super.validateValueInternal(rawValue);
        if (validValue == null) {
            validValue = false;
        }
        return validValue;
    }

    @Override
    protected Boolean parseValueInternal(String text) throws ProcessingException {
        Boolean retVal = null;
        if (text != null && text.length() == 0) {
            text = null;
        }
        if (text != null) {
            retVal = text.equals("1") ? Boolean.valueOf(true) : (text.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return retVal;
    }

    @Override
    public IBooleanFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements IBooleanFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setSelectedFromUI(boolean checked) {
            if (AbstractBooleanField.this.isEnabled() && AbstractBooleanField.this.isVisible()) {
                AbstractBooleanField.this.setChecked(checked);
            }
        }
    }
}

