/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.outline;

import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTreeForm;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;

public class DefaultOutlineTreeForm
extends AbstractForm
implements IOutlineTreeForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultOutlineTreeForm.class);
    private DesktopListener m_desktopListener;

    @Override
    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    @Override
    protected boolean getConfiguredCacheBounds() {
        return true;
    }

    @Override
    protected int getConfiguredDisplayHint() {
        return 20;
    }

    @Override
    protected String getConfiguredDisplayViewId() {
        return "OUTLINE";
    }

    @Override
    protected void execInitForm() throws ProcessingException {
        this.m_desktopListener = new DesktopListener(){

            @Override
            public void desktopChanged(DesktopEvent e) {
                switch (e.getType()) {
                    case 200: {
                        DefaultOutlineTreeForm.this.installTree(e.getOutline());
                    }
                }
            }
        };
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        desktop.addDesktopListener(this.m_desktopListener);
        this.installTree(desktop.getOutline());
    }

    @Override
    protected void execDisposeForm() throws ProcessingException {
        super.execDisposeForm();
        ClientSyncJob.getCurrentSession().getDesktop().removeDesktopListener(this.m_desktopListener);
        this.m_desktopListener = null;
    }

    private void installTree(ITree tree) {
        this.getOutlineTreeField().setTree(tree, true);
        if (tree != null) {
            this.setTitle(tree.getTitle());
            this.setIconId(tree.getIconId());
        }
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.OutlineTreeField getOutlineTreeField() {
        return this.getFieldByClass(MainBox.OutlineTreeField.class);
    }

    public void startView() throws ProcessingException {
        this.startInternal(new ViewHandler());
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Override
        protected String getConfiguredBorderDecoration() {
            return "empty";
        }

        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Order(value=10.0)
        public class OutlineTreeField
        extends AbstractTreeField {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected int getConfiguredGridW() {
                return 1;
            }

            @Override
            protected int getConfiguredGridH() {
                return 20;
            }
        }
    }

    @Order(value=10.0)
    public class ViewHandler
    extends AbstractFormHandler {
    }
}

