/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.file.IFileService;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

@Priority(value=-1.0f)
public class FileService
extends AbstractService
implements IFileService {
    private String m_rootPath = null;

    private Bundle getBundle() {
        return ClientSyncJob.getCurrentSession().getBundle();
    }

    @Override
    public File getLocalFile(String dir, String simpleName) throws ProcessingException {
        return this.getFileLocation(dir, simpleName, true);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName) throws ProcessingException {
        return this.getRemoteFile(dir, simpleName, null);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName, Locale locale) throws ProcessingException {
        return this.getRemoteFile(dir, simpleName, locale, true);
    }

    @Override
    public File getRemoteFile(String dir, String simpleName, Locale locale, boolean checkCache) throws ProcessingException {
        RemoteFile spec = null;
        File f = null;
        if (locale != null && simpleName != null && simpleName.lastIndexOf(".") != -1) {
            String filename = simpleName;
            String language = locale.toString().replaceAll("__", "_");
            String prefix = String.valueOf(filename.substring(0, filename.lastIndexOf("."))) + "_";
            String suffix = filename.substring(filename.lastIndexOf("."));
            filename = String.valueOf(prefix) + language + suffix;
            File test = this.getFileLocation(dir, filename, false);
            while (!test.exists()) {
                if (language.indexOf("_") == -1) {
                    filename = simpleName;
                    break;
                }
                language = language.substring(0, language.lastIndexOf("_"));
                filename = String.valueOf(prefix) + language + suffix;
                test = this.getFileLocation(dir, filename, false);
            }
            f = this.getFileLocation(dir, filename, false);
            spec = new RemoteFile(dir, filename, locale, 0L);
        } else {
            f = this.getFileLocation(dir, simpleName, false);
            spec = new RemoteFile(dir, simpleName, locale, 0L);
        }
        if (f.exists()) {
            spec.setLastModified(f.lastModified());
        }
        if (checkCache && OfflineState.isOnlineInCurrentThread()) {
            IRemoteFileService svc = (IRemoteFileService)SERVICES.getService(IRemoteFileService.class);
            spec = svc.getRemoteFile(spec);
            try {
                if (spec.getName() != null && !spec.getName().equalsIgnoreCase(f.getName())) {
                    if (locale != null && f.getName().length() > spec.getName().length()) {
                        f.delete();
                    }
                    f = this.getFileLocation(spec.getDirectory(), spec.getName(), false);
                }
                if (spec.exists() && spec.hasContent()) {
                    spec.writeData((OutputStream)new FileOutputStream(f));
                    f.setLastModified(spec.getLastModified());
                } else if (!spec.exists()) {
                    f.delete();
                }
            }
            catch (IOException e) {
                throw new ProcessingException("error writing remote file in local store", (Throwable)e);
            }
        }
        return f;
    }

    private String[][] getFiles(String folderBase, FilenameFilter filter, boolean useServerFolderStructureOnClient) throws ProcessingException {
        File path = this.getFileLocation(useServerFolderStructureOnClient ? folderBase : "", null, false);
        ArrayList<String> dirList = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        String[] dir = path.list(filter);
        int i = 0;
        while (i < dir.length) {
            try {
                File file = new File(String.valueOf(path.getCanonicalPath()) + "/" + dir[i]);
                if (file.exists() && file.isDirectory()) {
                    String[][] tmp;
                    String[][] stringArray = tmp = this.getFiles(folderBase == null ? dir[i] : String.valueOf(folderBase) + "/" + dir[i], filter, true);
                    int n = tmp.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] f = stringArray[n2];
                        dirList.add(f[0]);
                        fileList.add(f[1]);
                        ++n2;
                    }
                } else {
                    dirList.add(folderBase);
                    fileList.add(dir[i]);
                }
            }
            catch (IOException e) {
                throw new ProcessingException("FileService.getFiles:", (Throwable)e);
            }
            ++i;
        }
        String[][] retVal = new String[dirList.size()][2];
        int i2 = 0;
        while (i2 < dirList.size()) {
            retVal[i2][0] = (String)dirList.get(i2);
            retVal[i2][1] = (String)fileList.get(i2);
            ++i2;
        }
        return retVal;
    }

    @Override
    public void syncRemoteFilesToPath(String clientFolderPath, String serverFolderPath, FilenameFilter filter) throws ProcessingException {
        this.setDirectPath(clientFolderPath);
        this.syncRemoteFilesInternal(serverFolderPath, filter, false);
        this.setDirectPath(null);
    }

    @Override
    public void syncRemoteFiles(String serverFolderPath, FilenameFilter filter) throws ProcessingException {
        this.syncRemoteFilesInternal(serverFolderPath, filter, true);
    }

    private void syncRemoteFilesInternal(String serverFolderPath, FilenameFilter filter, boolean useServerFolderStructureOnClient) throws ProcessingException {
        IRemoteFileService svc = (IRemoteFileService)SERVICES.getService(IRemoteFileService.class);
        String[][] realFiles = this.getFiles(serverFolderPath, filter, useServerFolderStructureOnClient);
        RemoteFile[] existingFileInfoOnClient = new RemoteFile[realFiles.length];
        int i = 0;
        while (i < realFiles.length) {
            RemoteFile rf = new RemoteFile(realFiles[i][0], realFiles[i][1], 0L);
            String dir = this.m_rootPath == null ? realFiles[i][0] : "";
            File f = this.getFileLocation(dir, realFiles[i][1], false);
            if (f.exists()) {
                rf.setLastModified(f.lastModified());
            }
            existingFileInfoOnClient[i] = rf;
            ++i;
        }
        RemoteFile[] remoteFileArray = existingFileInfoOnClient = svc.getRemoteFiles(serverFolderPath, filter, existingFileInfoOnClient);
        int n = existingFileInfoOnClient.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteFile spec = remoteFileArray[n2];
            String fileDirectory = useServerFolderStructureOnClient ? spec.getDirectory() : null;
            File f = this.getFileLocation(fileDirectory, spec.getName(), false);
            if (spec.exists() && spec.hasContent()) {
                try {
                    if (spec.hasMoreParts()) {
                        int counter = 0;
                        long fileDate = spec.getLastModified();
                        File part = this.getFileLocation(fileDirectory, String.valueOf(spec.getName()) + "." + counter, false);
                        spec.writeData((OutputStream)new FileOutputStream(part));
                        part.setLastModified(fileDate);
                        RemoteFile specPart = spec;
                        while (specPart.hasMoreParts()) {
                            part = this.getFileLocation(fileDirectory, String.valueOf(spec.getName()) + "." + ++counter, false);
                            if (part.exists() && fileDate == part.lastModified()) continue;
                            specPart = svc.getRemoteFilePart(spec, (long)counter);
                            specPart.writeData((OutputStream)new FileOutputStream(part));
                            part.setLastModified(fileDate);
                        }
                        counter = 0;
                        f = this.getFileLocation(fileDirectory, spec.getName(), false);
                        FileOutputStream out = new FileOutputStream(f);
                        part = this.getFileLocation(fileDirectory, String.valueOf(spec.getName()) + "." + counter, false);
                        while (part.exists()) {
                            int len;
                            FileInputStream in = new FileInputStream(part);
                            byte[] buf = new byte[102400];
                            while ((len = ((InputStream)in).read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            out.flush();
                            ((InputStream)in).close();
                            part.delete();
                            part = this.getFileLocation(fileDirectory, String.valueOf(spec.getName()) + "." + ++counter, false);
                        }
                        ((OutputStream)out).close();
                        f.setLastModified(fileDate);
                    }
                    spec.writeData((OutputStream)new FileOutputStream(f));
                    f.setLastModified(spec.getLastModified());
                }
                catch (IOException e) {
                    throw new ProcessingException("error writing remote file in local store", (Throwable)e);
                }
            } else if (!spec.exists()) {
                f.delete();
            }
            ++n2;
        }
    }

    @Override
    public File getLocalFileLocation(String dir, String name) throws ProcessingException {
        return this.getFileLocation(dir, name, true);
    }

    @Override
    public File getRemoteFileLocation(String dir, String name) throws ProcessingException {
        return this.getFileLocation(dir, name, false);
    }

    private File getFileLocation(String dir, String name, boolean local) throws ProcessingException {
        try {
            File file;
            String path = this.m_rootPath;
            if (path == null) {
                path = Platform.getStateLocation((Bundle)this.getBundle()).toFile().getCanonicalPath();
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                path = local ? String.valueOf(path) + "local" : String.valueOf(path) + "remote";
            }
            if (dir != null) {
                if (!(dir = dir.replace("\\", "/")).startsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                path = String.valueOf(path) + dir;
            }
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            if (!(file = new File(path)).exists()) {
                file.mkdirs();
            }
            if (name != null) {
                file = new File(String.valueOf(path) + name);
            }
            return file;
        }
        catch (IOException e) {
            throw new ProcessingException("io error getting file", (Throwable)e);
        }
    }

    private void setDirectPath(String rootPath) {
        this.m_rootPath = rootPath;
    }
}

