/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.test;

import java.util.ArrayList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.test.AbstractClientTest;
import org.eclipse.scout.rt.client.services.common.test.ClientTestUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;

public class DuplicateMnemonicUnitTest
extends AbstractClientTest {
    public void run() throws Exception {
        this.checkMenus("top level", ClientTestUtility.getDesktop().getMenus());
    }

    public void checkMenus(String subTitle, IMenu[] menus) throws ProcessingException {
        IMenu menu;
        this.setSubTitle(subTitle);
        ArrayList<Character> mnemonics = new ArrayList<Character>();
        IMenu[] iMenuArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            menu = iMenuArray[n2];
            Character m = Character.valueOf(menu.getMnemonic());
            if (m != null && m.charValue() > '\u0000') {
                if (mnemonics.contains(m)) {
                    this.addWarningStatus("duplicate mnemonic " + m);
                } else {
                    this.addOkStatus("mnemonic " + m);
                }
                mnemonics.add(m);
            }
            ++n2;
        }
        iMenuArray = menus;
        n = menus.length;
        n2 = 0;
        while (n2 < n) {
            menu = iMenuArray[n2];
            if (menu.getChildActions().size() > 0 && menu.isVisible()) {
                IMenu[] childs = menu.getChildActions().toArray(new IMenu[menu.getChildActions().size()]);
                this.checkMenus(String.valueOf(menu.getText()) + " [" + menu.getClass().getSimpleName() + "]", childs);
            }
            ++n2;
        }
    }

    protected String getConfiguredTitle() {
        return "menubar: duplicate mnemonic on any level";
    }
}

