/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.cell;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.CellExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.CellStyle;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellSpecialization;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class Cell
implements ICell {
    private static final Map<CellStyle, CellStyle> SHARED_STYLE_STORE;
    private static final Object SHARED_STYLE_STORE_LOCK;
    private static final CellStyle DEFAULT_CELL_STYLE;
    private ICellObserver m_observer;
    private Object m_value;
    private String m_text;
    private ICellSpecialization m_cellSpecialization = DEFAULT_CELL_STYLE;

    static {
        SHARED_STYLE_STORE_LOCK = new Object();
        SHARED_STYLE_STORE = new HashMap<CellStyle, CellStyle>();
        DEFAULT_CELL_STYLE = new CellStyle();
        SHARED_STYLE_STORE.put(DEFAULT_CELL_STYLE, DEFAULT_CELL_STYLE);
    }

    public Cell() {
    }

    public Cell(ICell c) {
        try {
            this.updateFrom(c);
        }
        catch (ProcessingException e) {
            e.printStackTrace();
        }
    }

    public Cell(ICellObserver observer) {
        this.setObserver(observer);
    }

    public Cell(ICellObserver observer, ICell c) throws ProcessingException {
        this.updateFrom(c);
        this.setObserver(observer);
    }

    public void updateFrom(ICell c) throws ProcessingException {
        if (c != null) {
            this.setFont(c.getFont());
            this.setForegroundColor(c.getForegroundColor());
            this.setBackgroundColor(c.getBackgroundColor());
            this.setHorizontalAlignment(c.getHorizontalAlignment());
            this.setTooltipText(c.getTooltipText());
            this.setIconId(c.getIconId());
            this.setText(c.getText());
            this.setValue(c.getValue());
            this.setEnabled(c.isEnabled());
        }
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    public boolean setValue(Object value) throws ProcessingException {
        if (this.getObserver() != null) {
            value = this.getObserver().validateValue(this, value);
        }
        if (CompareUtility.equals((Object)this.m_value, (Object)value)) {
            return false;
        }
        this.m_value = value;
        if (this.getObserver() != null) {
            this.getObserver().cellChanged(this, 1);
        }
        return true;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        if (CompareUtility.notEquals((Object)this.m_text, (Object)s)) {
            this.m_text = s;
            if (this.getObserver() != null) {
                this.getObserver().cellChanged(this, 2);
            }
        }
    }

    @Override
    public String getIconId() {
        return this.m_cellSpecialization.getIconId();
    }

    public void setIconId(String s) {
        if (CompareUtility.notEquals((Object)this.m_cellSpecialization.getIconId(), (Object)s)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setIconId(s);
            this.setValueInternal(3, newStyle);
        }
    }

    @Override
    public String getTooltipText() {
        return this.m_cellSpecialization.getTooltipText();
    }

    public void setTooltipText(String s) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (!StringUtility.isNullOrEmpty((String)s)) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setTooltipText(s);
                this.setValueInternal(4, newStyle);
            }
        } else if (CompareUtility.notEquals((Object)this.m_cellSpecialization.getIconId(), (Object)s)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setTooltipText(s);
            this.setValueInternal(4, newStyle);
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_cellSpecialization.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(int a) {
        if (this.m_cellSpecialization.getHorizontalAlignment() != a) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setHorizontalAlignment(a);
            this.setValueInternal(5, newStyle);
        }
    }

    @Override
    public String getBackgroundColor() {
        return this.m_cellSpecialization.getBackgroundColor();
    }

    public void setBackgroundColor(String c) {
        if (CompareUtility.notEquals((Object)this.m_cellSpecialization.getBackgroundColor(), (Object)c)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setBackgroundColor(c);
            this.setValueInternal(6, newStyle);
        }
    }

    @Override
    public String getForegroundColor() {
        return this.m_cellSpecialization.getForegroundColor();
    }

    public void setForegroundColor(String c) {
        if (CompareUtility.notEquals((Object)this.m_cellSpecialization.getForegroundColor(), (Object)c)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setForegroundColor(c);
            this.setValueInternal(7, newStyle);
        }
    }

    @Override
    public FontSpec getFont() {
        return this.m_cellSpecialization.getFont();
    }

    public void setFont(FontSpec f) {
        if (this.m_cellSpecialization.getFont() == null && f != null || this.m_cellSpecialization.getFont() != null && f == null || CompareUtility.notEquals((Object)this.m_cellSpecialization.getFont(), (Object)f)) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setFont(f);
            this.setValueInternal(8, newStyle);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_cellSpecialization.isEnabled();
    }

    public void setEnabled(boolean b) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (!b) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setEnabled(b);
                this.setValueInternal(9, newStyle);
            }
        } else if (this.m_cellSpecialization.isEnabled() != b) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setEnabled(b);
            this.setValueInternal(9, newStyle);
        }
    }

    @Override
    public boolean isEditable() {
        return this.m_cellSpecialization.isEditable();
    }

    public void setEditableInternal(boolean b) {
        if (this.m_cellSpecialization instanceof CellStyle) {
            if (b) {
                CellExtension newStyle = new CellExtension(this.m_cellSpecialization);
                newStyle.setEditable(b);
                this.setValueInternal(10, newStyle);
            }
        } else if (this.m_cellSpecialization.isEditable() != b) {
            ICellSpecialization newStyle = this.m_cellSpecialization.copy();
            newStyle.setEditable(b);
            this.setValueInternal(10, newStyle);
        }
    }

    @Override
    public ICellObserver getObserver() {
        return this.m_observer;
    }

    public void setObserver(ICellObserver observer) {
        this.m_observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueInternal(int bitPos, ICellSpecialization cellSpecialization) {
        Object object = SHARED_STYLE_STORE_LOCK;
        synchronized (object) {
            CellStyle newStyle = cellSpecialization.getCellStyle();
            CellStyle sharedStyle = SHARED_STYLE_STORE.get(newStyle);
            if (sharedStyle == null) {
                SHARED_STYLE_STORE.put(newStyle, newStyle);
                this.m_cellSpecialization = cellSpecialization.reconcile(newStyle);
            } else {
                this.m_cellSpecialization = cellSpecialization.reconcile(sharedStyle);
            }
        }
        if (this.getObserver() != null) {
            this.getObserver().cellChanged(this, bitPos);
        }
    }

    public String toString() {
        String s = this.getText();
        if (s == null) {
            s = "" + this.getValue();
        }
        return s;
    }
}

