/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractTableRowBuilder {
    public ITableRow createTableRow(LookupRow dataRow) throws ProcessingException {
        ITableRow tableRow = this.createEmptyTableRow();
        tableRow.setEnabled(dataRow.isEnabled());
        Cell cell = tableRow.getCellForUpdate(1);
        if (dataRow.getTooltipText() != null) {
            cell.setTooltipText(dataRow.getTooltipText());
        }
        if (dataRow.getIconId() != null) {
            cell.setIconId(dataRow.getIconId());
        }
        if (dataRow.getBackgroundColor() != null) {
            cell.setBackgroundColor(dataRow.getBackgroundColor());
        }
        if (dataRow.getForegroundColor() != null) {
            cell.setForegroundColor(dataRow.getForegroundColor());
        }
        if (dataRow.getFont() != null) {
            cell.setFont(dataRow.getFont());
        }
        tableRow.setStatusNonchanged();
        return tableRow;
    }

    public ITableRow createRow() throws ProcessingException {
        return this.createEmptyTableRow();
    }

    public ITableRow createRow(Object rowValues) throws ProcessingException {
        if (!rowValues.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be an array value []");
        }
        ITableRow row = this.createEmptyTableRow();
        int c = 0;
        int nc = Array.getLength(rowValues);
        while (c < nc) {
            row.setCellValue(c, Array.get(rowValues, c));
            ++c;
        }
        return row;
    }

    public ITableRow[] createRowsByArray(Object dataArray) throws ProcessingException {
        return this.createRowsByArray(dataArray, 1);
    }

    public ITableRow[] createRowsByArray(Object dataArray, int rowStatus) throws ProcessingException {
        if (dataArray == null) {
            dataArray = new Object[]{};
        }
        if (dataArray instanceof Collection) {
            dataArray = ((Collection)dataArray).toArray();
        }
        if (!dataArray.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be a matrix value [][]");
        }
        ITableRow[] rows = new ITableRow[Array.getLength(dataArray)];
        int r = 0;
        while (r < rows.length) {
            rows[r] = this.createRow(new Object[]{Array.get(dataArray, r)});
            ++r;
        }
        return rows;
    }

    public ITableRow[] createRowsByMatrix(Object dataMatrixOrReference) throws ProcessingException {
        return this.createRowsByMatrix(dataMatrixOrReference, 1);
    }

    public ITableRow[] createRowsByMatrix(Object dataMatrixOrReference, int rowStatus) throws ProcessingException {
        Object[][] dataMatrix;
        boolean isRef;
        if (dataMatrixOrReference instanceof AtomicReference) {
            isRef = true;
            dataMatrix = ((AtomicReference)dataMatrixOrReference).get();
        } else {
            isRef = false;
            dataMatrix = dataMatrixOrReference;
        }
        if (dataMatrix == null) {
            dataMatrix = new Object[0][0];
        }
        if (!dataMatrix.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be a matrix value [][]");
        }
        ITableRow[] rows = new ITableRow[Array.getLength(dataMatrix)];
        if (isRef) {
            Object[] refData = new Object[rows.length];
            int r = 0;
            while (r < rows.length) {
                refData[r] = Array.get(dataMatrix, r);
                ++r;
            }
            dataMatrix = null;
            ((AtomicReference)dataMatrixOrReference).set(null);
            dataMatrix = null;
            r = 0;
            while (r < rows.length) {
                rows[r] = this.createRow(refData[r]);
                refData[r] = null;
                rows[r].setStatus(rowStatus);
                ++r;
            }
        } else {
            int r = 0;
            while (r < rows.length) {
                rows[r] = this.createRow(Array.get(dataMatrix, r));
                rows[r].setStatus(rowStatus);
                ++r;
            }
        }
        return rows;
    }

    public ITableRow[] createRowsByCodes(ICode[] codes) throws ProcessingException {
        ITableRow[] rows = new ITableRow[codes.length];
        int i = 0;
        while (i < rows.length) {
            rows[i] = this.createRow(new Object[]{codes[i].getId(), codes[i].getText()});
            rows[i].setIconId(codes[i].getIconId());
            rows[i].setBackgroundColor(codes[i].getBackgroundColor());
            rows[i].setForegroundColor(codes[i].getForegroundColor());
            rows[i].setFont(codes[i].getFont());
            ++i;
        }
        return rows;
    }

    protected abstract ITableRow createEmptyTableRow();
}

