/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.net.URL;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.AbstractSplitBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.AbstractWrappedFormField;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStatusField;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class DefaultWizardContainerForm
extends AbstractWizardContainerForm
implements IWizardContainerForm {
    public DefaultWizardContainerForm(IWizard w) throws ProcessingException {
        super(w);
    }

    @Override
    protected String getConfiguredIconId() {
        return AbstractIcons.Gears;
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.SplitBox getSplitBox() {
        return this.getFieldByClass(MainBox.SplitBox.class);
    }

    public MainBox.SplitBox.ContentBox getContentBox() {
        return this.getFieldByClass(MainBox.SplitBox.ContentBox.class);
    }

    public MainBox.SplitBox.ContentBox.WrappedWizardForm getWrappedWizardForm() {
        return this.getFieldByClass(MainBox.SplitBox.ContentBox.WrappedWizardForm.class);
    }

    public MainBox.SplitBox.StatusField getStatusField() {
        return this.getFieldByClass(MainBox.SplitBox.StatusField.class);
    }

    @Override
    public IButton getWizardCancelButton() {
        return this.getFieldByClass(MainBox.WizardCancelButton.class);
    }

    @Override
    public IButton getWizardSuspendButton() {
        return this.getFieldByClass(MainBox.WizardSuspendButton.class);
    }

    @Override
    public IButton getWizardResetButton() {
        return this.getFieldByClass(MainBox.WizardResetButton.class);
    }

    @Override
    public IButton getWizardPreviousStepButton() {
        return this.getFieldByClass(MainBox.WizardPreviousStepButton.class);
    }

    @Override
    public IButton getWizardNextStepButton() {
        return this.getFieldByClass(MainBox.WizardNextStepButton.class);
    }

    @Override
    public IButton getWizardFinishButton() {
        return this.getFieldByClass(MainBox.WizardFinishButton.class);
    }

    @Override
    protected final IForm getInnerWizardForm() {
        return this.getWrappedWizardForm().getInnerForm();
    }

    @Override
    protected final void setInnerWizardForm(IForm form) {
        this.getWrappedWizardForm().setInnerForm(form);
    }

    @Override
    public void startWizard() throws ProcessingException {
        this.startInternal(new WizardHandler());
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridW() {
            return 3;
        }

        @Override
        protected int getConfiguredGridH() {
            return 32;
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return false;
        }

        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        public class EnterKeyStroke
        extends AbstractKeyStroke {
            @Override
            protected String getConfiguredKeyStroke() {
                return "enter";
            }

            @Override
            protected void execAction() throws ProcessingException {
                DefaultWizardContainerForm.this.handleEnterKey();
            }
        }

        public class EscapeKeyStroke
        extends AbstractKeyStroke {
            @Override
            protected String getConfiguredKeyStroke() {
                return "escape";
            }

            @Override
            protected void execAction() throws ProcessingException {
                DefaultWizardContainerForm.this.handleEscapeKey(false);
            }
        }

        @Order(value=10.0)
        public class SplitBox
        extends AbstractSplitBox {
            @Override
            protected int getConfiguredGridH() {
                return 2;
            }

            @Override
            protected double getConfiguredSplitterPosition() {
                return 0.75;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Order(value=10.0)
            public class ContentBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 6;
                }

                @Override
                protected String getConfiguredBorderDecoration() {
                    return "empty";
                }

                @Order(value=10.0)
                public class WrappedWizardForm
                extends AbstractWrappedFormField<IForm> {
                    @Override
                    protected int getConfiguredGridW() {
                        return 2;
                    }

                    @Override
                    protected int getConfiguredGridH() {
                        return 8;
                    }
                }
            }

            @Order(value=20.0)
            public class StatusField
            extends AbstractWizardStatusField {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 2;
                }

                @Override
                protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
                    if (DefaultWizardContainerForm.this.getWizard() != null) {
                        DefaultWizardContainerForm.this.getWizard().doHyperlinkAction(url, path, local);
                    } else {
                        super.execHyperlinkAction(url, path, local);
                    }
                }
            }
        }

        @Order(value=10.0)
        public class WizardCancelButton
        extends AbstractButton
        implements IButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"WizardCancelButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"WizardCancelButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return -1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doCancel();
            }
        }

        @Order(value=50.0)
        public class WizardFinishButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"WizardFinishButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"WizardFinishButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return 1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doFinish();
            }
        }

        @Order(value=40.0)
        public class WizardNextStepButton
        extends AbstractButton {
            @Override
            protected String getConfiguredIconId() {
                return AbstractIcons.WizardNextButton;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"WizardNextButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"WizardNextButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return 1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doNextStep();
            }
        }

        @Order(value=30.0)
        public class WizardPreviousStepButton
        extends AbstractButton {
            @Override
            protected String getConfiguredIconId() {
                return AbstractIcons.WizardBackButton;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"WizardBackButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"WizardBackButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return 1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doPreviousStep();
            }
        }

        @Order(value=25.0)
        public class WizardResetButton
        extends AbstractButton
        implements IButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ResetButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"ResetButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return -1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doReset();
            }
        }

        @Order(value=20.0)
        public class WizardSuspendButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"WizardSuspendButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"WizardSuspendButtonTooltip", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected int getConfiguredHorizontalAlignment() {
                return -1;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultWizardContainerForm.this.getWizard().doSuspend();
            }
        }
    }

    public class WizardHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            if (DefaultWizardContainerForm.this.getWizard() != null) {
                DefaultWizardContainerForm.this.setInnerWizardForm(DefaultWizardContainerForm.this.getWizard().getWizardForm());
            } else {
                DefaultWizardContainerForm.this.setInnerWizardForm(null);
            }
        }
    }
}

