/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceRegistry
implements IInstanceRegistry {
    private List<IInstance> instances = new ArrayList<IInstance>();
    private static InstanceRegistry _instance;

    private InstanceRegistry() {
    }

    public static InstanceRegistry getInstance() {
        if (_instance == null) {
            _instance = new InstanceRegistry();
        }
        return _instance;
    }

    @Override
    public ImageDescriptor getImage() {
        return DevicePlugin.getDefault().getImageDescriptor("ICON_DEVICE");
    }

    @Override
    public List<IInstance> getInstances() {
        InstanceManager.getInstance();
        return this.instances;
    }

    @Override
    public void setInstances(List<IInstance> instance) {
        this.instances = instance;
    }

    @Override
    public void addInstance(IInstance instance) {
        this.instances.add(instance);
        InstanceEventManager.getInstance().fireInstanceLoaded(new InstanceEvent(instance));
    }

    @Override
    public void removeInstance(IInstance instance) {
        this.instances.remove(instance);
        InstanceEventManager.getInstance().fireInstanceUnloaded(new InstanceEvent(instance));
    }

    @Override
    public void clear() {
        this.instances.clear();
    }
}

