/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.exception.DeviceExceptionHandler;
import org.eclipse.sequoyah.device.framework.internal.model.MobileService;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.status.IStatusTransition;
import org.eclipse.sequoyah.device.framework.status.MobileStatusTransition;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ServiceFactory {
    private static final String ELEMENT_SERVICE = "service";
    private static final String ELEMENT_STATUS = "status";
    private static final String ATR_START_ID = "startId";
    private static final String ATR_END_ID = "endId";
    private static final String ATR_HALT_ID = "haltId";
    private static final String ATR_ID = "id";
    private static final String ATR_NAME = "name";
    private static final String ATR_ICON = "icon";
    private static final String ATR_DESCRIPTION = "description";
    private static final String ATR_PROVIDER = "provider";
    private static final String ATR_COPYRIGHT = "copyright";
    private static final String ATR_VERSION = "version";
    private static final String ATR_HANDLER = "handler";
    private static final String ATR_VISIBLE = "visible";

    public static IService createService(IExtension iExtension, String string, IServiceHandler iServiceHandler) throws SequoyahException {
        Object object;
        IExtension iExtension2 = PluginUtils.getExtension((String)"org.eclipse.sequoyah.device.framework.service", (String)string);
        ArrayList<IStatusTransition> arrayList = new ArrayList<IStatusTransition>();
        if (iExtension2 == null) {
            throw new SequoyahException();
        }
        MobileService mobileService = new MobileService(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_ID));
        mobileService.setName(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_NAME));
        String string2 = PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_ICON);
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)iExtension2.getContributor().getName(), (String)string2);
        }
        catch (Throwable throwable) {
            ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
        }
        mobileService.setImage(imageDescriptor);
        mobileService.setDescription(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_DESCRIPTION));
        mobileService.setProvider(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_PROVIDER));
        mobileService.setCopyright(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_COPYRIGHT));
        mobileService.setVersion(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_VERSION));
        mobileService.setVisible(new Boolean(PluginUtils.getPluginAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_VISIBLE)));
        try {
            object = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension2, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
            if (iServiceHandler != null) {
                iServiceHandler.setParent((IServiceHandler)object);
                mobileService.setHandler(iServiceHandler);
            } else {
                mobileService.setHandler((IServiceHandler)object);
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
        }
        if (iExtension != null) {
            object = PluginUtils.getPluginElementList((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ELEMENT_STATUS);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator.next();
                String string3 = iConfigurationElement.getAttribute(ATR_START_ID);
                String string4 = iConfigurationElement.getAttribute(ATR_END_ID);
                String string5 = iConfigurationElement.getAttribute(ATR_HALT_ID);
                MobileStatusTransition mobileStatusTransition = new MobileStatusTransition(string3, string4, string5);
                arrayList.add(mobileStatusTransition);
            }
        }
        mobileService.setStatusTransitions(arrayList);
        return mobileService;
    }

    public static IService createService(String string) throws SequoyahException {
        return ServiceFactory.createService(null, string, null);
    }

    public static IService createService(IExtension iExtension) throws SequoyahException {
        String string = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_ID);
        IServiceHandler iServiceHandler = null;
        try {
            iServiceHandler = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
        }
        catch (CoreException coreException) {}
        return ServiceFactory.createService(iExtension, string, iServiceHandler);
    }
}

