/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.stringeditor.editor.input.AbstractStringEditorInput;
import org.eclipse.sequoyah.localization.stringeditor.providers.ContentProvider;
import org.eclipse.sequoyah.localization.stringeditor.providers.DefaultOperationProvider;
import org.eclipse.sequoyah.localization.stringeditor.providers.ICellValidator;
import org.eclipse.sequoyah.localization.stringeditor.providers.IOperationProvider;

public class EditorExtensionLoader {
    private static final String EXTENSION_POINT_ID = "contentprovider";
    private static final String PROVIDER_ELEMENT_ID = "provider";
    private static final String PROVIDER_EDITOR_CONTEXT_HELP_ID = "contextHelpID";
    private static final String PROVIDER_EDITOR_INPUT_ID = "editorInput";
    private static final String PROVIDER_OPERATION_PROV_ID = "operationsProvider";
    private static final String PROVIDER_CELL_VALIDATOR_ID = "cellValidator";
    private final Map<IFile, IConfigurationElement> knownProviders = new HashMap<IFile, IConfigurationElement>();
    private final List<IConfigurationElement> availableElements = new ArrayList<IConfigurationElement>();
    private static EditorExtensionLoader instance;

    private EditorExtensionLoader() {
        this.loadExtensions();
    }

    private void loadExtensions() {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.sequoyah.localization.stringeditor", EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if (iConfigurationElement.getName().equals(PROVIDER_ELEMENT_ID)) {
                this.availableElements.add(iConfigurationElement);
            }
            ++n2;
        }
    }

    public ContentProvider getContentProviderForFileInput(IFile iFile) {
        ContentProvider contentProvider = null;
        IConfigurationElement iConfigurationElement = this.knownProviders.get(iFile);
        if (iConfigurationElement == null) {
            iConfigurationElement = this.searchElementForFile(iFile);
        }
        if (iConfigurationElement != null) {
            contentProvider = EditorExtensionLoader.createContentProviderFromElement(iConfigurationElement);
        }
        return contentProvider;
    }

    private IConfigurationElement searchElementForFile(IFile iFile) {
        IConfigurationElement iConfigurationElement = null;
        int n = 0;
        while (iConfigurationElement == null && n < this.availableElements.size()) {
            IConfigurationElement iConfigurationElement2 = this.availableElements.get(n);
            ContentProvider contentProvider = EditorExtensionLoader.createContentProviderFromElement(iConfigurationElement2);
            if (contentProvider.getEditorInput().canHandle(iFile)) {
                iConfigurationElement = iConfigurationElement2;
                this.knownProviders.put(iFile, iConfigurationElement2);
                contentProvider = null;
            }
            ++n;
        }
        return iConfigurationElement;
    }

    private static ContentProvider createContentProviderFromElement(IConfigurationElement iConfigurationElement) {
        ContentProvider contentProvider = null;
        String string = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            object = iConfigurationElement.createExecutableExtension(PROVIDER_EDITOR_INPUT_ID);
            object2 = iConfigurationElement.createExecutableExtension(PROVIDER_OPERATION_PROV_ID);
            object3 = iConfigurationElement.createExecutableExtension(PROVIDER_CELL_VALIDATOR_ID);
            string = iConfigurationElement.getAttribute(PROVIDER_EDITOR_CONTEXT_HELP_ID);
        }
        catch (CoreException coreException) {
            BasePlugin.logWarning((String)("No operation provider found for " + iConfigurationElement.getDeclaringExtension().getUniqueIdentifier() + ". Using a default operation provider."));
        }
        AbstractStringEditorInput abstractStringEditorInput = null;
        IOperationProvider iOperationProvider = null;
        ICellValidator iCellValidator = null;
        if (object instanceof AbstractStringEditorInput) {
            abstractStringEditorInput = (AbstractStringEditorInput)object;
        }
        iOperationProvider = object2 instanceof IOperationProvider ? (IOperationProvider)object2 : new DefaultOperationProvider();
        if (object3 instanceof ICellValidator) {
            iCellValidator = (ICellValidator)object3;
        }
        if (abstractStringEditorInput != null) {
            contentProvider = new ContentProvider(abstractStringEditorInput, iOperationProvider, iCellValidator, string.length() > 0 ? string : null);
        }
        return contentProvider;
    }

    public static final EditorExtensionLoader getInstance() {
        if (instance == null) {
            instance = new EditorExtensionLoader();
        }
        return instance;
    }
}

