/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.manager;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.exception.DeviceExceptionHandler;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.persistence.DeviceXmlWriter;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IDeviceLauncher;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.sequoyah.device.framework.model.handler.IDeviceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.UndefinedDeviceHandler;
import org.eclipse.sequoyah.device.framework.statemachine.StateMachineHandler;

public class InstanceManager {
    private static final String ELEMENT_DEVICE = "deviceType";
    private static final String ATTR_HANDLER = "handler";
    private static IInstance currentInstance;

    public static void setInstance(IInstance iInstance) {
        currentInstance = iInstance;
    }

    public static IInstance getCurrentInstance() {
        return currentInstance;
    }

    public static IDeviceLauncher createLauncher(IInstance iInstance) throws SequoyahException {
        IDeviceHandler iDeviceHandler = null;
        IDeviceLauncher iDeviceLauncher = null;
        try {
            IExtension iExtension = PluginUtils.getExtension((String)"org.eclipse.sequoyah.device.framework.deviceTypes", (String)iInstance.getDeviceTypeId());
            iDeviceHandler = (IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)ATTR_HANDLER);
            iDeviceLauncher = iDeviceHandler.createDeviceLauncher(iInstance);
        }
        catch (CoreException coreException) {
            ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
        }
        return iDeviceLauncher;
    }

    public static IInstance createInstance(String string, String string2, String string3, Properties properties) throws SequoyahException {
        IDeviceHandler iDeviceHandler = null;
        IInstance iInstance = null;
        try {
            IExtension iExtension = PluginUtils.getExtension((String)"org.eclipse.sequoyah.device.framework.deviceTypes", (String)string2);
            if (iExtension != null) {
                iDeviceHandler = (IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)ATTR_HANDLER);
                if (iDeviceHandler == null) {
                    throw DeviceExceptionHandler.exception(202);
                }
            } else {
                iDeviceHandler = new UndefinedDeviceHandler();
            }
            iInstance = iDeviceHandler.createDeviceInstance(String.valueOf(string) + string2);
            iInstance.setDeviceTypeId(string2);
            iInstance.setName(string);
            if (iExtension != null) {
                ((AbstractMobileInstance)iInstance).setStateMachineHandler(new StateMachineHandler(iInstance));
                iInstance.setStatus(string3);
            }
            iInstance.setProperties((Properties)properties.clone());
        }
        catch (CoreException coreException) {
            throw DeviceExceptionHandler.exception(202);
        }
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_CREATED, iInstance));
        return iInstance;
    }

    public static void deleteInstance(IInstance iInstance) {
        if (currentInstance == iInstance) {
            currentInstance = null;
        }
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        instanceRegistry.removeInstance(iInstance);
        DeviceXmlWriter.saveInstances();
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_DELETED, iInstance));
    }

    public static void createProject(IDeviceType iDeviceType, IInstanceBuilder iInstanceBuilder, IProgressMonitor iProgressMonitor) throws SequoyahException {
        IInstance iInstance = InstanceManager.createInstance(iInstanceBuilder.getProjectName(), iDeviceType.getId(), "OFF", iInstanceBuilder.getProperties());
        if (currentInstance == null) {
            currentInstance = iInstance;
        }
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        instanceRegistry.addInstance(iInstance);
        DeviceXmlWriter.saveInstances();
    }
}

