/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationProject;
import org.eclipse.sequoyah.localization.tools.datamodel.StringArray;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRowInputDialog
extends Dialog {
    private final int DEFAULT_NUM_ENTRIES = 1;
    private final int LIMIT_NUM_ENTRIES_SIZE = 2;
    private IProject project = null;
    ILocalizationSchema localizationSchema = null;
    private String dialogTitle = null;
    private String key;
    private boolean isArray = false;
    private int numEntries = 1;
    Label errorMsg = null;
    Combo addNewCombo = null;
    Label newString = null;
    Text textNewString = null;
    Button newArray = null;
    Text textNewArray = null;
    Text unitsNewArray = null;
    Button existingArray = null;
    Combo arraysCombo = null;
    Text unitsExistingArray = null;
    Label unitsNewArrayLabel = null;
    Label unitsExistingLabel = null;

    public NewRowInputDialog(Shell shell, IProject iProject, String string) {
        super(shell);
        this.project = iProject;
        this.localizationSchema = LocalizationManager.getInstance().getLocalizationSchema(iProject);
        this.dialogTitle = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.errorMsg = new Label(composite2, 0);
        this.errorMsg.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.errorMsg.setForeground(new Color((Device)this.getShell().getDisplay(), new RGB(255, 0, 0)));
        this.createSelectionGroup(composite2);
        this.createStringGroup(composite2);
        this.createArrayGroup(composite2);
        this.setInitialValues();
        return composite2;
    }

    private void createSelectionGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.NewRowDialog_AddNew);
        this.addNewCombo = new Combo(composite, 12);
        this.addNewCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addNewCombo.setItems(new String[]{Messages.NewRowDialog_String, Messages.NewRowDialog_Array});
        this.addNewCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Combo)selectionEvent.getSource()).getText().equals(Messages.NewRowDialog_String)) {
                    NewRowInputDialog.this.isArray = false;
                    NewRowInputDialog.this.enableArraysArea(false);
                    NewRowInputDialog.this.enableStringsArea(true);
                    NewRowInputDialog.this.validateSelection();
                } else {
                    NewRowInputDialog.this.isArray = true;
                    NewRowInputDialog.this.enableStringsArea(false);
                    NewRowInputDialog.this.enableArraysArea(true);
                    NewRowInputDialog.this.validateSelection();
                }
            }
        });
    }

    private void createStringGroup(Composite composite) {
        Group group = new Group(composite, 64);
        group.setText(Messages.NewRowDialog_String);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        this.newString = new Label((Composite)group, 16);
        this.newString.setText(Messages.NewRowDialog_RowKey);
        this.textNewString = new Text((Composite)group, 2048);
        this.textNewString.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textNewString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewRowInputDialog.this.key = NewRowInputDialog.this.textNewString.getText();
                NewRowInputDialog.this.validateSelection();
            }
        });
    }

    private void createArrayGroup(Composite composite) {
        Group group = new Group(composite, 64);
        group.setText(Messages.NewRowDialog_Array);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        group.setLayout((Layout)new GridLayout(4, false));
        this.existingArray = new Button((Composite)group, 16);
        this.existingArray.setText(Messages.NewRowDialog_AddToArray);
        this.existingArray.setSelection(true);
        this.existingArray.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewRowInputDialog.this.enableArraysArea(true);
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.arraysCombo = new Combo((Composite)group, 12);
        this.arraysCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.arraysCombo.setItems(this.getAllStringArrayNames());
        this.arraysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewRowInputDialog.this.key = ((Combo)selectionEvent.getSource()).getText();
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.unitsExistingArray = new Text((Composite)group, 2048);
        this.unitsExistingArray.setText(String.valueOf(1));
        this.setEntriesTextSize(this.unitsExistingArray);
        this.unitsExistingArray.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewRowInputDialog.this.numEntries = Integer.parseInt(NewRowInputDialog.this.unitsExistingArray.getText());
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.unitsExistingLabel = new Label((Composite)group, 0);
        this.unitsExistingLabel.setText(Messages.NewRowDialog_Entries);
        this.newArray = new Button((Composite)group, 16);
        this.newArray.setText(Messages.NewRowDialog_NewArray);
        this.newArray.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewRowInputDialog.this.enableArraysArea(true);
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.textNewArray = new Text((Composite)group, 2048);
        this.textNewArray.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textNewArray.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewRowInputDialog.this.key = NewRowInputDialog.this.textNewArray.getText();
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.unitsNewArray = new Text((Composite)group, 2048);
        this.unitsNewArray.setText(String.valueOf(1));
        this.setEntriesTextSize(this.unitsNewArray);
        this.unitsNewArray.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewRowInputDialog.this.numEntries = Integer.parseInt(NewRowInputDialog.this.unitsNewArray.getText());
                NewRowInputDialog.this.validateSelection();
            }
        });
        this.unitsNewArrayLabel = new Label((Composite)group, 0);
        this.unitsNewArrayLabel.setText(Messages.NewRowDialog_Entries);
    }

    private void setEntriesTextSize(Text text) {
        GC gC = new GC((Drawable)text);
        FontMetrics fontMetrics = gC.getFontMetrics();
        GridData gridData = new GridData();
        gridData.widthHint = 3 * fontMetrics.getAverageCharWidth();
        text.setLayoutData((Object)gridData);
        text.setTextLimit(2);
    }

    private String[] getAllStringArrayNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        LocalizationProject localizationProject = null;
        try {
            localizationProject = LocalizationManager.getInstance().getProjectLocalizationManager(this.project, false).getLocalizationProject();
        }
        catch (IOException iOException) {}
        Set<StringArray> set = localizationProject.getAllStringArrays();
        Iterator<StringArray> iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getKey());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void setInitialValues() {
        this.addNewCombo.select(0);
        this.textNewString.setFocus();
        this.enableArraysArea(false);
        this.enableStringsArea(true);
        this.key = this.textNewString.getText();
    }

    private void enableStringsArea(boolean bl) {
        this.newString.setEnabled(bl);
        this.textNewString.setEnabled(bl);
        this.textNewString.setFocus();
    }

    private void enableArraysArea(boolean bl) {
        this.newArray.setEnabled(bl);
        this.existingArray.setEnabled(bl);
        if (!bl) {
            this.enableNewArrayWidgets(bl);
            this.enableExistingArrayWidgets(bl);
        } else if (this.newArray.getSelection()) {
            this.enableNewArrayWidgets(bl);
            this.enableExistingArrayWidgets(!bl);
            this.textNewArray.forceFocus();
        } else {
            this.enableExistingArrayWidgets(bl);
            this.enableNewArrayWidgets(!bl);
            this.arraysCombo.forceFocus();
        }
    }

    private void enableNewArrayWidgets(boolean bl) {
        this.textNewArray.setEnabled(bl);
        this.unitsNewArray.setEnabled(bl);
        this.unitsNewArrayLabel.setEnabled(bl);
    }

    private void enableExistingArrayWidgets(boolean bl) {
        this.arraysCombo.setEnabled(bl);
        this.unitsExistingArray.setEnabled(bl);
        this.unitsExistingLabel.setEnabled(bl);
    }

    private void validateSelection() {
        boolean bl = true;
        String string = "";
        boolean bl2 = this.localizationSchema.keyAcceptsBlankSpaces();
        if (!bl2 && this.textNewString.getText().contains(" ")) {
            string = Messages.NewRowDialog_Error_RowKeyHasBlankSpaces;
            bl = false;
        } else if (this.addNewCombo.getText().equals(Messages.NewRowDialog_String)) {
            if (this.textNewString.getText().trim().length() == 0) {
                bl = false;
            }
        } else if (this.existingArray.getSelection()) {
            if (this.arraysCombo.getText().equals("")) {
                bl = false;
            }
            try {
                int n = Integer.parseInt(this.unitsExistingArray.getText());
                if (n <= 0) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else {
            if (this.textNewArray.getText().trim().length() == 0) {
                bl = false;
            }
            try {
                int n = Integer.parseInt(this.unitsNewArray.getText());
                if (n <= 0) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        this.getButton(0).setEnabled(bl);
        this.errorMsg.setText(string);
    }
}

